/*
 * Decompiled with CFR 0.152.
 */
package dev.marksman.composablerandom;

import com.jnape.palatable.lambda.functions.builtin.fn1.Id;
import com.jnape.palatable.lambda.functions.builtin.fn2.Eq;
import com.jnape.palatable.lambda.functions.builtin.fn2.GTE;
import com.jnape.palatable.lambda.functions.builtin.fn2.LT;
import com.jnape.palatable.lambda.functions.builtin.fn2.LTE;
import dev.marksman.composablerandom.Generate;
import dev.marksman.composablerandom.Initialize;
import dev.marksman.composablerandom.RandomState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import testsupport.Assert;
import testsupport.Sample;

class PrimitivesTest {
    PrimitivesTest() {
    }

    @Test
    void testIntInclusiveInBounds() {
        Assert.assertForAll(Generate.generateInt((int)0, (int)0), Eq.eq((Object)0));
        Assert.assertForAll(Generate.generateInt((int)-256, (int)256), n -> n >= -256 && n <= 256);
        Assert.assertForAll(Generate.generateInt((int)0, (int)1), n -> n == 0 || n == 1);
        Assert.assertForAll(Generate.generateInt((int)-1, (int)1), n -> n >= -1 && n <= 1);
        Assert.assertForAll(Generate.generateInt((int)-1, (int)1), n -> n >= -1 && n <= 1);
        Assert.assertForAll(Generate.generateInt((int)Integer.MIN_VALUE, (int)0), LTE.lte((Comparable)Integer.valueOf(0)));
        Assert.assertForAll(Generate.generateInt((int)Integer.MIN_VALUE, (int)-1), LT.lt((Comparable)Integer.valueOf(0)));
        Assert.assertForAll(Generate.generateInt((int)0, (int)Integer.MAX_VALUE), GTE.gte((Comparable)Integer.valueOf(0)));
        Assert.assertForAll(Generate.generateInt((int)0, (int)Integer.MAX_VALUE), GTE.gte((Comparable)Integer.valueOf(0)));
        Assert.assertForAll(Generate.generateInt().flatMap(lowerBound -> Generate.generateInt((int)lowerBound, (int)Integer.MAX_VALUE).flatMap(upperBound -> Generate.generateInt((int)lowerBound, (int)upperBound).fmap(n -> n >= lowerBound && n <= upperBound))), Id.id());
    }

    @Test
    void testIntExclusiveInBounds() {
        Assert.assertForAll(Generate.generateIntExclusive((int)Integer.MAX_VALUE), GTE.gte((Comparable)Integer.valueOf(0)));
        Assert.assertForAll(Generate.generateIntExclusive((int)Integer.MAX_VALUE).flatMap(Generate::generateIntExclusive), GTE.gte((Comparable)Integer.valueOf(0)));
        Assert.assertForAll(Generate.generateInt((int)Integer.MIN_VALUE, (int)0x7FFFFFFE).flatMap(lowerBound -> Generate.generateInt((int)(lowerBound + 1), (int)Integer.MAX_VALUE).flatMap(upperBound -> Generate.generateIntExclusive((int)lowerBound, (int)upperBound).fmap(n -> n >= lowerBound && n < upperBound))), Id.id());
    }

    @Test
    void testIntFullRange() {
        RandomState initial = Initialize.randomInitialRandomState();
        Assertions.assertEquals(Sample.sample(Generate.generateInt((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE), initial), Sample.sample(Generate.generateInt(), initial));
    }

    @Test
    void testLongInclusiveInBounds() {
        Assert.assertForAll(Generate.generateLong((long)0L, (long)0L), Eq.eq((Object)0L));
        Assert.assertForAll(Generate.generateLong((long)-256L, (long)256L), n -> n >= -256L && n <= 256L);
        Assert.assertForAll(Generate.generateLong((long)0L, (long)1L), n -> n == 0L || n == 1L);
        Assert.assertForAll(Generate.generateLong((long)-1L, (long)1L), n -> n >= -1L && n <= 1L);
        Assert.assertForAll(Generate.generateLong((long)-1L, (long)1L), n -> n >= -1L && n <= 1L);
        Assert.assertForAll(Generate.generateLong((long)Long.MIN_VALUE, (long)0L), LTE.lte((Comparable)Long.valueOf(0L)));
        Assert.assertForAll(Generate.generateLong((long)Long.MIN_VALUE, (long)-1L), LT.lt((Comparable)Long.valueOf(0L)));
        Assert.assertForAll(Generate.generateLong((long)0L, (long)Long.MAX_VALUE), GTE.gte((Comparable)Long.valueOf(0L)));
        Assert.assertForAll(Generate.generateLong((long)0L, (long)Long.MAX_VALUE), GTE.gte((Comparable)Long.valueOf(0L)));
        Assert.assertForAll(Generate.generateLong().flatMap(lowerBound -> Generate.generateLong((long)lowerBound, (long)Long.MAX_VALUE).flatMap(upperBound -> Generate.generateLong((long)lowerBound, (long)upperBound).fmap(n -> n >= lowerBound && n <= upperBound))), Id.id());
    }

    @Test
    void testLongExclusiveInBounds() {
        Assert.assertForAll(Generate.generateLongExclusive((long)Long.MAX_VALUE), GTE.gte((Comparable)Long.valueOf(0L)));
        Assert.assertForAll(Generate.generateLongExclusive((long)Long.MAX_VALUE).flatMap(Generate::generateLongExclusive), GTE.gte((Comparable)Long.valueOf(0L)));
        Assert.assertForAll(Generate.generateLong((long)Long.MIN_VALUE, (long)0x7FFFFFFFFFFFFFFEL).flatMap(lowerBound -> Generate.generateLong((long)(lowerBound + 1L), (long)Long.MAX_VALUE).flatMap(upperBound -> Generate.generateLongExclusive((long)lowerBound, (long)upperBound).fmap(n -> n >= lowerBound && n < upperBound))), Id.id());
    }

    @Test
    void testLongFullRange() {
        RandomState initial = Initialize.randomInitialRandomState();
        Assertions.assertEquals(Sample.sample(Generate.generateLong((long)Long.MIN_VALUE, (long)Long.MAX_VALUE), initial), Sample.sample(Generate.generateLong(), initial));
    }

    @Test
    void testDoubleBetween0and1() {
        Assert.assertForAll(Generate.generateDouble(), n -> n >= 0.0 && n <= 1.0);
    }

    @Test
    void testDoubleScaledInBounds() {
        Assert.assertForAll(Generate.generateDouble((double)999.0), n -> n >= 0.0 && n <= 999.0);
        Assert.assertForAll(Generate.generateDouble((double)-999.0), n -> n >= -999.0 && n <= 0.0);
    }

    @Test
    void testFloatBetween0and1() {
        Assert.assertForAll(Generate.generateFloat(), n -> n.floatValue() >= 0.0f && n.floatValue() <= 1.0f);
    }

    @Test
    void testFloatScaledInBounds() {
        Assert.assertForAll(Generate.generateFloat((float)999.0f), n -> n.floatValue() >= 0.0f && n.floatValue() <= 999.0f);
        Assert.assertForAll(Generate.generateFloat((float)-999.0f), n -> n.floatValue() >= -999.0f && n.floatValue() <= 0.0f);
    }
}

