/*
 * Decompiled with CFR 0.152.
 */
package dev.marksman.composablerandom.random;

import com.jnape.palatable.lambda.adt.product.Product2;
import com.jnape.palatable.lambda.functions.Fn1;
import dev.marksman.composablerandom.RandomState;
import dev.marksman.composablerandom.random.StandardGen;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import testsupport.GeneratorPair;

class StandardGenTest {
    private static final int SEQUENCE_LENGTH = 32;

    StandardGenTest() {
    }

    @Test
    void nextInt() {
        this.testAgainstUtilRandom(Random::nextInt, RandomState::nextInt);
    }

    @Test
    void nextIntWithBound() {
        this.testAgainstUtilRandom(r -> r.nextInt(1), r -> r.nextIntBounded(1));
        this.testAgainstUtilRandom(r -> r.nextInt(255), r -> r.nextIntBounded(255));
        this.testAgainstUtilRandom(r -> r.nextInt(256), r -> r.nextIntBounded(256));
        this.testAgainstUtilRandom(r -> r.nextInt(Integer.MAX_VALUE), r -> r.nextIntBounded(Integer.MAX_VALUE));
    }

    @Test
    void nextIntWithInvalidBound() {
        GeneratorPair gp = GeneratorPair.newRandomGeneratorPair();
        Assertions.assertThrows(IllegalArgumentException.class, () -> gp.getRandomState().nextIntBounded(0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> gp.getRandomState().nextIntBounded(-1));
    }

    @Test
    void nextDouble() {
        this.testAgainstUtilRandom(Random::nextDouble, RandomState::nextDouble);
    }

    @Test
    void nextFloat() {
        this.testAgainstUtilRandom(Random::nextFloat, RandomState::nextFloat);
    }

    @Test
    void nextLong() {
        this.testAgainstUtilRandom(Random::nextLong, RandomState::nextLong);
    }

    @Test
    void nextBoolean() {
        this.testAgainstUtilRandom(Random::nextBoolean, RandomState::nextBoolean);
    }

    @Test
    void nextGaussian() {
        this.testAgainstUtilRandom(Random::nextGaussian, RandomState::nextGaussian);
    }

    @Test
    void nextBytes() {
        StandardGenTest.testNextBytes(GeneratorPair.newRandomGeneratorPair(), 1);
        StandardGenTest.testNextBytes(GeneratorPair.newRandomGeneratorPair(), 2);
        StandardGenTest.testNextBytes(GeneratorPair.newRandomGeneratorPair(), 3);
        StandardGenTest.testNextBytes(GeneratorPair.newRandomGeneratorPair(), 4);
        StandardGenTest.testNextBytes(GeneratorPair.newRandomGeneratorPair(), 5);
    }

    @Test
    void mixed() {
        GeneratorPair gp = GeneratorPair.newRandomGeneratorPair();
        gp = this.testAgainstUtilRandom(gp, 1, Random::nextInt, RandomState::nextInt);
        gp = this.testAgainstUtilRandom(gp, 1, r -> r.nextInt(10), r -> r.nextIntBounded(10));
        gp = this.testAgainstUtilRandom(gp, 1, Random::nextDouble, RandomState::nextDouble);
        gp = this.testAgainstUtilRandom(gp, 1, Random::nextFloat, RandomState::nextFloat);
        gp = this.testAgainstUtilRandom(gp, 1, Random::nextLong, RandomState::nextLong);
        gp = this.testAgainstUtilRandom(gp, 1, Random::nextBoolean, RandomState::nextBoolean);
        this.testAgainstUtilRandom(gp, 1, Random::nextGaussian, RandomState::nextGaussian);
    }

    @Test
    void withCachedGaussian() {
        GeneratorPair gp = GeneratorPair.newRandomGeneratorPair();
        gp = this.testAgainstUtilRandom(gp, 1, Random::nextGaussian, RandomState::nextGaussian);
        gp = this.testAgainstUtilRandom(gp, 1, Random::nextInt, RandomState::nextInt);
        gp = this.testAgainstUtilRandom(gp, 1, r -> r.nextInt(10), r -> r.nextIntBounded(10));
        gp = this.testAgainstUtilRandom(gp, 1, Random::nextDouble, RandomState::nextDouble);
        gp = this.testAgainstUtilRandom(gp, 1, Random::nextFloat, RandomState::nextFloat);
        gp = this.testAgainstUtilRandom(gp, 1, Random::nextLong, RandomState::nextLong);
        gp = this.testAgainstUtilRandom(gp, 1, Random::nextBoolean, RandomState::nextBoolean);
        gp = this.testAgainstUtilRandom(gp, 1, Random::nextGaussian, RandomState::nextGaussian);
        this.testAgainstUtilRandom(gp, 1, Random::nextInt, RandomState::nextInt);
    }

    @Test
    void nextBytesWithCachedGaussian() {
        GeneratorPair gp = GeneratorPair.newRandomGeneratorPair();
        gp.getRandom().nextGaussian();
        StandardGenTest.testNextBytes(gp.updateRandomState((Fn1<RandomState, RandomState>)((Fn1)r -> (RandomState)r.nextGaussian()._1())), 4);
    }

    @Test
    void noMethodsMutate() {
        StandardGen randomGen = StandardGen.initStandardGen();
        long seed = randomGen.getSeedValue();
        randomGen.nextInt();
        Assertions.assertEquals((long)seed, (long)randomGen.getSeedValue());
        randomGen.nextIntBounded(10);
        Assertions.assertEquals((long)seed, (long)randomGen.getSeedValue());
        randomGen.nextDouble();
        Assertions.assertEquals((long)seed, (long)randomGen.getSeedValue());
        randomGen.nextFloat();
        Assertions.assertEquals((long)seed, (long)randomGen.getSeedValue());
        randomGen.nextLong();
        Assertions.assertEquals((long)seed, (long)randomGen.getSeedValue());
        randomGen.nextBoolean();
        Assertions.assertEquals((long)seed, (long)randomGen.getSeedValue());
        randomGen.nextGaussian();
        Assertions.assertEquals((long)seed, (long)randomGen.getSeedValue());
        randomGen.nextBytes(new byte[4]);
        Assertions.assertEquals((long)seed, (long)randomGen.getSeedValue());
    }

    private <A> void testAgainstUtilRandom(Fn1<Random, A> getNextExpected, Fn1<RandomState, Product2<? extends RandomState, A>> getNextResult) {
        GeneratorPair gp = GeneratorPair.newRandomGeneratorPair();
        this.testAgainstUtilRandom(gp, 32, getNextExpected, getNextResult);
    }

    private <A> GeneratorPair testAgainstUtilRandom(GeneratorPair gp, int times, Fn1<Random, A> getNextExpected, Fn1<RandomState, Product2<? extends RandomState, A>> getNextResult) {
        RandomState current = gp.getRandomState();
        Random random = gp.getRandom();
        for (int i = 0; i < times; ++i) {
            Object expected = getNextExpected.apply((Object)random);
            Product2 next = (Product2)getNextResult.apply((Object)current);
            current = (RandomState)next._1();
            Object actual = next._2();
            Assertions.assertEquals((Object)expected, (Object)actual, (String)("index " + i + ", " + gp.info()));
        }
        return gp.withRandomState(current);
    }

    private static void testNextBytes(GeneratorPair gp, int count) {
        byte[] expected = new byte[count];
        byte[] actual = new byte[count];
        gp.getRandom().nextBytes(expected);
        gp.getRandomState().nextBytes(actual);
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual, (String)gp.info());
    }
}

