/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.jnape.palatable.lambda.functions.builtin.fn2.Into;
import dev.marksman.collectionviews.NonEmptyVector;
import dev.marksman.collectionviews.Vector;
import dev.marksman.composablerandom.Generate;
import dev.marksman.composablerandom.GeneratedStream;

public class ShuffleExample {
    private static NonEmptyVector<Suit> suits = Vector.of((Object)((Object)Suit.CLUBS), (Object[])new Suit[]{Suit.HEARTS, Suit.SPADES, Suit.DIAMONDS});
    private static NonEmptyVector<Rank> ranks = Vector.of((Object)((Object)Rank.TWO), (Object[])new Rank[]{Rank.THREE, Rank.FOUR, Rank.FIVE, Rank.SIX, Rank.SEVEN, Rank.EIGHT, Rank.NINE, Rank.TEN, Rank.JACK, Rank.QUEEN, Rank.KING, Rank.ACE});
    private static NonEmptyVector<Card> cards = suits.cross(ranks).fmap(Into.into(Card::card));
    private static Generate<NonEmptyVector<Card>> generateDeck = Generate.generateShuffled(cards);

    public static void main(String[] args) {
        GeneratedStream.streamFrom(generateDeck).next(10).forEach(System.out::println);
    }

    private static final class Card {
        private final Suit suit;
        private final Rank rank;

        static Card card(Suit suit, Rank rank) {
            return new Card(suit, rank);
        }

        public String toString() {
            return this.rank.getDisplayName() + this.suit.getDisplayName();
        }

        public Suit getSuit() {
            return this.suit;
        }

        public Rank getRank() {
            return this.rank;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Card)) {
                return false;
            }
            Card other = (Card)o;
            Suit this$suit = this.getSuit();
            Suit other$suit = other.getSuit();
            if (this$suit == null ? other$suit != null : !((Object)((Object)this$suit)).equals((Object)other$suit)) {
                return false;
            }
            Rank this$rank = this.getRank();
            Rank other$rank = other.getRank();
            return !(this$rank == null ? other$rank != null : !((Object)((Object)this$rank)).equals((Object)other$rank));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Suit $suit = this.getSuit();
            result = result * 59 + ($suit == null ? 43 : ((Object)((Object)$suit)).hashCode());
            Rank $rank = this.getRank();
            result = result * 59 + ($rank == null ? 43 : ((Object)((Object)$rank)).hashCode());
            return result;
        }

        private Card(Suit suit, Rank rank) {
            this.suit = suit;
            this.rank = rank;
        }
    }

    static enum Rank {
        TWO("2"),
        THREE("3"),
        FOUR("4"),
        FIVE("5"),
        SIX("6"),
        SEVEN("7"),
        EIGHT("8"),
        NINE("9"),
        TEN("10"),
        JACK("J"),
        QUEEN("Q"),
        KING("K"),
        ACE("A");

        private String displayName;

        private Rank(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    static enum Suit {
        CLUBS("\u00e2\u2122\u00a3"),
        HEARTS("\u00e2\u2122\u00a5"),
        SPADES("\u00e2\u2122\u00a0"),
        DIAMONDS("\u00e2\u2122\u00a6");

        private String displayName;

        private Suit(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

