/*
 * Decompiled with CFR 0.152.
 */
package examples.components;

import com.jnape.palatable.lambda.adt.Maybe;
import com.jnape.palatable.lambda.functions.builtin.fn2.Into;
import dev.marksman.composablerandom.Generate;
import dev.marksman.composablerandom.MaybeWeights;
import dev.marksman.composablerandom.frequency.FrequencyMap;
import examples.components.City;
import examples.components.Street;
import examples.components.UsState;
import examples.components.ZipCode;

public final class Address {
    private final String number;
    private final Street street;
    private final Maybe<String> unit;
    private final City city;
    private final UsState state;
    private final ZipCode zipCode;

    public String prettyMultiLine() {
        return this.renderPretty(true);
    }

    public String prettySingleLine() {
        return this.renderPretty(false);
    }

    private String renderPretty(boolean multiLine) {
        return this.number + " " + this.street.pretty() + (String)this.unit.orElse((Object)"") + (multiLine ? "\n" : "; ") + this.city.pretty() + ", " + this.state.pretty() + " " + this.zipCode.pretty();
    }

    public static Generate<Address> generateAddress() {
        return generators.address;
    }

    public static Address address(String number, Street street, Maybe<String> unit, City city, UsState state, ZipCode zipCode) {
        return new Address(number, street, unit, city, state, zipCode);
    }

    public String getNumber() {
        return this.number;
    }

    public Street getStreet() {
        return this.street;
    }

    public Maybe<String> getUnit() {
        return this.unit;
    }

    public City getCity() {
        return this.city;
    }

    public UsState getState() {
        return this.state;
    }

    public ZipCode getZipCode() {
        return this.zipCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address other = (Address)o;
        String this$number = this.getNumber();
        String other$number = other.getNumber();
        if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
            return false;
        }
        Street this$street = this.getStreet();
        Street other$street = other.getStreet();
        if (this$street == null ? other$street != null : !((Object)this$street).equals(other$street)) {
            return false;
        }
        Maybe<String> this$unit = this.getUnit();
        Maybe<String> other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        City this$city = this.getCity();
        City other$city = other.getCity();
        if (this$city == null ? other$city != null : !((Object)this$city).equals(other$city)) {
            return false;
        }
        UsState this$state = this.getState();
        UsState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        ZipCode this$zipCode = this.getZipCode();
        ZipCode other$zipCode = other.getZipCode();
        return !(this$zipCode == null ? other$zipCode != null : !((Object)this$zipCode).equals(other$zipCode));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : $number.hashCode());
        Street $street = this.getStreet();
        result = result * 59 + ($street == null ? 43 : ((Object)$street).hashCode());
        Maybe<String> $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        City $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : ((Object)$city).hashCode());
        UsState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        ZipCode $zipCode = this.getZipCode();
        result = result * 59 + ($zipCode == null ? 43 : ((Object)$zipCode).hashCode());
        return result;
    }

    public String toString() {
        return "Address(number=" + this.getNumber() + ", street=" + this.getStreet() + ", unit=" + this.getUnit() + ", city=" + this.getCity() + ", state=" + this.getState() + ", zipCode=" + this.getZipCode() + ")";
    }

    private Address(String number, Street street, Maybe<String> unit, City city, UsState state, ZipCode zipCode) {
        this.number = number;
        this.street = street;
        this.unit = unit;
        this.city = city;
        this.state = state;
        this.zipCode = zipCode;
    }

    private static class generators {
        static Generate<String> number = FrequencyMap.frequencyMap((int)3, (Generate)Generate.generateInt((int)0, (int)990).fmap(n -> 100 + 10 * n)).add(3, Generate.generateInt((int)0, (int)990).fmap(n -> 101 + 10 * n)).add(4, Generate.generateInt((int)10, (int)999)).toGenerate().fmap(Object::toString);
        static Generate<String> unit = Generate.tupled((Generate)Generate.chooseOneOfValues((Object)" #", (Object[])new String[]{", Apt. ", ", Suite "}), (Generate)Generate.chooseOneOf((Generate)Generate.generateInt((int)100, (int)3000), (Generate[])new Generate[]{Generate.generateInt((int)1, (int)99)})).fmap(Into.into((unitName, number) -> unitName + number));
        static Generate<Address> address = Generate.product(generators.number, Street.generateStreet(), (Generate)unit.maybe(MaybeWeights.nothingWeight((int)4).toJust(1)), City.generateCity(), UsState.generateUsState(), ZipCode.generateZipCode(), Address::address);

        private generators() {
        }
    }
}

