/*
 * Decompiled with CFR 0.152.
 */
package examples.components;

import com.jnape.palatable.lambda.functions.builtin.fn2.Into3;
import dev.marksman.composablerandom.Generate;
import dev.marksman.composablerandom.GeneratedStream;
import dev.marksman.composablerandom.MaybeWeights;
import dev.marksman.composablerandom.frequency.FrequencyMap;

public final class City {
    private final String name;

    public static City city(String name) {
        return new City(name);
    }

    public String pretty() {
        return this.name;
    }

    public static Generate<String> generateCityRootName() {
        return generators.rootName;
    }

    public static Generate<City> generateCity() {
        return generators.city;
    }

    public static void main(String[] args) {
        GeneratedStream.streamFrom(City.generateCity()).next(100).forEach(System.out::println);
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof City)) {
            return false;
        }
        City other = (City)o;
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "City(name=" + this.getName() + ")";
    }

    private City(String name) {
        this.name = name;
    }

    private static class generators {
        static Generate<String> prefix = Generate.chooseOneOfValues((Object)"North ", (Object[])new String[]{"South ", "East ", "West ", "Upper ", "Lower ", "New "});
        static Generate<String> part1 = Generate.chooseOneOfValues((Object)"Ash", (Object[])new String[]{"Bar", "Baz", "Brook", "Butter", "East", "Fair", "Foo", "Fox", "Frost", "Glen", "Gold", "Green", "Hamp", "Haver", "Hemp", "Lee", "Long", "Maple", "Middle", "North", "Oak", "Old", "Park", "Pine", "Quux", "Shelby", "Sher", "Silver", "South", "Spring", "Stam", "Stath", "Wander", "West", "Willow", "Wind", "Wood"});
        static Generate<String> part2Component = Generate.chooseOneOfValues((Object)"borne", (Object[])new String[]{"brook", "bury", "caster", "chester", "crest", "dale", "field", "ford", "ham", "haven", "holme", "hurst", "ingham", "ington", "kirk", "ley", "mere", "more", "mouth", "owoc", "pine", "ram", "shire", "side", "stead", "ston", "swick", "ton", "town", "view", "ville", "wich", "wick", "win", "wood", "worth"});
        static Generate<String> part2 = FrequencyMap.frequencyMap((int)10, part2Component).add(4, Generate.generateString((int)2, part2Component)).add(1, Generate.generateString((int)3, part2Component)).toGenerate();
        static Generate<String> suffix = Generate.chooseOneOfValues((Object)" Park", (Object[])new String[]{" Village", " Grove", " Heights", " Town", " City", " Springs", " River"});
        static Generate<String> rootName = Generate.generateString(part1, (Generate[])new Generate[]{part2});
        static Generate<City> city = Generate.tupled((Generate)generators.prefix.maybe(MaybeWeights.nothingWeight((int)5).toJust(1)).fmap(p -> (String)p.orElse((Object)"")), rootName, (Generate)generators.suffix.maybe(MaybeWeights.nothingWeight((int)5).toJust(1)).fmap(s -> (String)s.orElse((Object)""))).fmap(Into3.into3((prefix, root, suffix) -> City.city(prefix + root + suffix)));

        private generators() {
        }
    }
}

