/*
 * Decompiled with CFR 0.152.
 */
package examples.components;

import com.jnape.palatable.lambda.adt.Maybe;
import com.jnape.palatable.lambda.functions.builtin.fn2.Into4;
import dev.marksman.collectionviews.NonEmptyVector;
import dev.marksman.composablerandom.FrequencyEntry;
import dev.marksman.composablerandom.Generate;
import dev.marksman.composablerandom.GeneratedStream;
import dev.marksman.composablerandom.MaybeWeights;
import dev.marksman.composablerandom.domain.Characters;
import java.util.Arrays;

public final class Name {
    private final String first;
    private final Maybe<String> middle;
    private final String last;
    private final Maybe<String> suffix;

    public String pretty() {
        return this.first + (String)this.middle.match(__ -> "", s -> " " + s) + " " + this.last + (String)this.suffix.match(__ -> "", s -> ", " + s);
    }

    public static Name name(String first, Maybe<String> middle, String last, Maybe<String> suffix) {
        return new Name(first, middle, last, suffix);
    }

    public static Generate<Name> generateName() {
        return generators.name;
    }

    public static void main(String[] args) {
        GeneratedStream.streamFrom((Generate)Generate.generateNonEmptyMap((Generate)Generate.generateInt((int)0, (int)255), (Generate)Name.generateName().fmap(Name::pretty))).next(100).forEach(System.out::println);
    }

    public String getFirst() {
        return this.first;
    }

    public Maybe<String> getMiddle() {
        return this.middle;
    }

    public String getLast() {
        return this.last;
    }

    public Maybe<String> getSuffix() {
        return this.suffix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Name)) {
            return false;
        }
        Name other = (Name)o;
        String this$first = this.getFirst();
        String other$first = other.getFirst();
        if (this$first == null ? other$first != null : !this$first.equals(other$first)) {
            return false;
        }
        Maybe<String> this$middle = this.getMiddle();
        Maybe<String> other$middle = other.getMiddle();
        if (this$middle == null ? other$middle != null : !this$middle.equals(other$middle)) {
            return false;
        }
        String this$last = this.getLast();
        String other$last = other.getLast();
        if (this$last == null ? other$last != null : !this$last.equals(other$last)) {
            return false;
        }
        Maybe<String> this$suffix = this.getSuffix();
        Maybe<String> other$suffix = other.getSuffix();
        return !(this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $first = this.getFirst();
        result = result * 59 + ($first == null ? 43 : $first.hashCode());
        Maybe<String> $middle = this.getMiddle();
        result = result * 59 + ($middle == null ? 43 : $middle.hashCode());
        String $last = this.getLast();
        result = result * 59 + ($last == null ? 43 : $last.hashCode());
        Maybe<String> $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        return result;
    }

    public String toString() {
        return "Name(first=" + this.getFirst() + ", middle=" + this.getMiddle() + ", last=" + this.getLast() + ", suffix=" + this.getSuffix() + ")";
    }

    private Name(String first, Maybe<String> middle, String last, Maybe<String> suffix) {
        this.first = first;
        this.middle = middle;
        this.last = last;
        this.suffix = suffix;
    }

    private static class generators {
        static final Generate<String> initial = Generate.chooseOneFromDomain((NonEmptyVector)Characters.alphaUpper()).fmap(c -> c + ".");
        static final Generate<String> givenNames = Generate.chooseOneOfValues((Object)"Alice", (Object[])new String[]{"Barbara", "Bart", "Billy", "Bobby", "Carol", "Cindy", "Elizabeth", "Eric", "George", "Greg", "Homer", "James", "Jan", "John", "Kenny", "Kyle", "Linda", "Lisa", "Maggie", "Marcia", "Marge", "Mary", "Mike", "Oliver", "Patricia", "Peter", "Stan"});
        static final Generate<String> first = Generate.frequency((FrequencyEntry)FrequencyEntry.entry((int)15, givenNames), (FrequencyEntry[])new FrequencyEntry[]{FrequencyEntry.entry((int)1, initial)});
        static final Generate<String> middle = Generate.frequency((FrequencyEntry)FrequencyEntry.entry((int)1, givenNames), (FrequencyEntry[])new FrequencyEntry[]{FrequencyEntry.entry((int)5, initial)});
        static final Generate<String> last = Generate.chooseOneFromCollection(Arrays.asList("Allen", "Anderson", "Brown", "Clark", "Davis", "Foobar", "Garcia", "Hall", "Harris", "Hernandez", "Jackson", "Johnson", "Jones", "King", "Lee", "Lewis", "Lopez", "Martin", "Martinez", "Miller", "Moore", "Qwerty", "Robinson", "Rodriguez", "Smith", "Taylor", "Thomas", "Thompson", "Walker", "White", "Williams", "Wilson", "Wright", "Young"));
        static final Generate<String> suffix = Generate.chooseOneOfValues((Object)"Jr.", (Object[])new String[]{"III", "Sr."});
        static final Generate<Name> name = Generate.tupled(first, (Generate)middle.maybe(MaybeWeights.nothingWeight((int)6).toJust(1)), last, (Generate)suffix.maybe(MaybeWeights.nothingWeight((int)19).toJust(1))).fmap(Into4.into4(Name::name));

        private generators() {
        }
    }
}

