/*
 * Decompiled with CFR 0.152.
 */
package examples.components;

import com.jnape.palatable.lambda.functions.builtin.fn2.Into3;
import dev.marksman.composablerandom.Generate;
import dev.marksman.composablerandom.GeneratedStream;
import dev.marksman.composablerandom.frequency.FrequencyMap;
import examples.components.Address;
import examples.components.Name;
import java.time.LocalDate;
import java.time.Year;

public final class Person {
    private final Name name;
    private final Address address;
    private final LocalDate dateOfBirth;

    public String pretty() {
        return "Person {\n  Name: " + this.name.pretty() + "\n  Address: " + this.address.prettySingleLine() + "\n  Date of birth: " + this.dateOfBirth + "\n}\n";
    }

    public static Person person(Name name, Address address, LocalDate dateOfBirth) {
        return new Person(name, address, dateOfBirth);
    }

    public static Generate<Person> generatePerson() {
        return generators.person;
    }

    public static void main(String[] args) {
        GeneratedStream.streamFrom((Generate)Person.generatePerson().fmap(Person::pretty)).next(100).forEach(System.out::println);
    }

    public Name getName() {
        return this.name;
    }

    public Address getAddress() {
        return this.address;
    }

    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Person)) {
            return false;
        }
        Person other = (Person)o;
        Name this$name = this.getName();
        Name other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        LocalDate this$dateOfBirth = this.getDateOfBirth();
        LocalDate other$dateOfBirth = other.getDateOfBirth();
        return !(this$dateOfBirth == null ? other$dateOfBirth != null : !((Object)this$dateOfBirth).equals(other$dateOfBirth));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Name $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        LocalDate $dateOfBirth = this.getDateOfBirth();
        result = result * 59 + ($dateOfBirth == null ? 43 : ((Object)$dateOfBirth).hashCode());
        return result;
    }

    public String toString() {
        return "Person(name=" + this.getName() + ", address=" + this.getAddress() + ", dateOfBirth=" + this.getDateOfBirth() + ")";
    }

    private Person(Name name, Address address, LocalDate dateOfBirth) {
        this.name = name;
        this.address = address;
        this.dateOfBirth = dateOfBirth;
    }

    private static class generators {
        private static int currentYear = LocalDate.now().getYear();
        private static Generate<Integer> age = FrequencyMap.frequencyMap((int)1, (Generate)Generate.generateInt((int)2, (int)9)).add(2, Generate.generateInt((int)10, (int)19)).add(3, Generate.generateInt((int)20, (int)29)).add(3, Generate.generateInt((int)30, (int)39)).add(3, Generate.generateInt((int)40, (int)49)).add(3, Generate.generateInt((int)50, (int)59)).add(2, Generate.generateInt((int)60, (int)69)).add(2, Generate.generateInt((int)70, (int)79)).add(2, Generate.generateInt((int)80, (int)99)).toGenerate();
        private static Generate<LocalDate> dateOfBirth = age.flatMap(n -> Generate.generateLocalDateForYear((Year)Year.of(currentYear - n)));
        static Generate<Person> person = Generate.tupled(Name.generateName(), Address.generateAddress(), dateOfBirth).fmap(Into3.into3(Person::person));

        private generators() {
        }
    }
}

