/*
 * Decompiled with CFR 0.152.
 */
package examples.components;

import com.jnape.palatable.lambda.adt.Maybe;
import com.jnape.palatable.lambda.functions.builtin.fn2.Into3;
import dev.marksman.composablerandom.FrequencyEntry;
import dev.marksman.composablerandom.Generate;
import dev.marksman.composablerandom.GeneratedStream;
import dev.marksman.composablerandom.MaybeWeights;
import examples.components.City;

public final class Street {
    private final Maybe<String> compass;
    private final String name;
    private final String suffix;

    public String pretty() {
        return (String)this.compass.match(__ -> "", s -> s + " ") + this.name + " " + this.suffix;
    }

    public static Street street(Maybe<String> compass, String name, String suffix) {
        return new Street(compass, name, suffix);
    }

    public static Generate<Street> generateStreet() {
        return generators.street;
    }

    public static void main(String[] args) {
        GeneratedStream.streamFrom((Generate)Street.generateStreet().fmap(Street::pretty)).next(100).forEach(System.out::println);
    }

    public Maybe<String> getCompass() {
        return this.compass;
    }

    public String getName() {
        return this.name;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Street)) {
            return false;
        }
        Street other = (Street)o;
        Maybe<String> this$compass = this.getCompass();
        Maybe<String> other$compass = other.getCompass();
        if (this$compass == null ? other$compass != null : !this$compass.equals(other$compass)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        return !(this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Maybe<String> $compass = this.getCompass();
        result = result * 59 + ($compass == null ? 43 : $compass.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        return result;
    }

    public String toString() {
        return "Street(compass=" + this.getCompass() + ", name=" + this.getName() + ", suffix=" + this.getSuffix() + ")";
    }

    private Street(Maybe<String> compass, String name, String suffix) {
        this.compass = compass;
        this.name = name;
        this.suffix = suffix;
    }

    private static class generators {
        static final Generate<String> compass = Generate.frequency((FrequencyEntry)FrequencyEntry.entry((int)8, (Generate)Generate.chooseOneOfValues((Object)"N.", (Object[])new String[]{"S.", "W.", "E."})), (FrequencyEntry[])new FrequencyEntry[]{FrequencyEntry.entry((int)1, (Generate)Generate.chooseOneOfValues((Object)"NW", (Object[])new String[]{"NE", "SW", "SE"}))});
        static final Generate<String> ordinal = Generate.generateInt((int)1, (int)99).fmap(n -> {
            if (n == 11) {
                return "11th";
            }
            if (n % 10 == 1) {
                return n + "st";
            }
            if (n % 10 == 2) {
                return n + "nd";
            }
            if (n % 10 == 3) {
                return n + "rd";
            }
            return n + "th";
        });
        static final Generate<String> president = Generate.chooseOneOfValues((Object)"Washington", (Object[])new String[]{"Adams", "Jefferson", "Madison", "Monroe", "Lincoln"});
        static final Generate<String> tree = Generate.chooseOneOfValues((Object)"Oak", (Object[])new String[]{"Maple", "Elm", "Pine", "Spruce", "Sycamore", "Birch", "Apple", "Peach"});
        static final Generate<String> suffix = Generate.frequency((FrequencyEntry)FrequencyEntry.entryForValue((int)10, (Object)"St."), (FrequencyEntry[])new FrequencyEntry[]{FrequencyEntry.entryForValue((int)7, (Object)"Ave."), FrequencyEntry.entryForValue((int)5, (Object)"Rd."), FrequencyEntry.entryForValue((int)3, (Object)"Dr."), FrequencyEntry.entryForValue((int)3, (Object)"La."), FrequencyEntry.entryForValue((int)2, (Object)"Blvd."), FrequencyEntry.entryForValue((int)1, (Object)"Ct.")});
        static final Generate<String> name = Generate.frequency((FrequencyEntry)FrequencyEntry.entry((int)3, ordinal), (FrequencyEntry[])new FrequencyEntry[]{FrequencyEntry.entry((int)2, tree), FrequencyEntry.entry((int)2, president), FrequencyEntry.entry((int)2, City.generateCityRootName())});
        static final Generate<Street> street = Generate.tupled((Generate)compass.maybe(MaybeWeights.nothingWeight((int)3).toJust(1)), name, suffix).fmap(Into3.into3(Street::street));

        private generators() {
        }
    }
}

