/*
 * Decompiled with CFR 0.152.
 */
package testsupport;

import com.jnape.palatable.lambda.functions.Fn1;
import dev.marksman.composablerandom.RandomState;
import dev.marksman.composablerandom.random.StandardGen;
import java.util.Random;

public class GeneratorPair {
    private final long initialSeedValue;
    private final Random random;
    private final RandomState randomState;

    public long getInitialSeedValue() {
        return this.initialSeedValue;
    }

    public Random getRandom() {
        return this.random;
    }

    public RandomState getRandomState() {
        return this.randomState;
    }

    public GeneratorPair withRandomState(RandomState rs) {
        return new GeneratorPair(this.initialSeedValue, this.random, rs);
    }

    public GeneratorPair updateRandomState(Fn1<RandomState, RandomState> f) {
        return this.withRandomState((RandomState)f.apply((Object)this.randomState));
    }

    public String info() {
        return "initial seed = " + this.initialSeedValue;
    }

    public static GeneratorPair generatorPair(long initialSeedValue) {
        Random random = new Random();
        random.setSeed(initialSeedValue);
        StandardGen standardGen = StandardGen.initStandardGen((long)initialSeedValue);
        return new GeneratorPair(initialSeedValue, random, (RandomState)standardGen);
    }

    public static GeneratorPair newRandomGeneratorPair() {
        return GeneratorPair.generatorPair(new Random().nextLong());
    }

    private GeneratorPair(long initialSeedValue, Random random, RandomState randomState) {
        this.initialSeedValue = initialSeedValue;
        this.random = random;
        this.randomState = randomState;
    }
}

