/*
 * Decompiled with CFR 0.152.
 */
package masecla.modrinth4j.client.instances;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import masecla.modrinth4j.client.HttpClient;
import masecla.modrinth4j.client.agent.UserAgent;
import okhttp3.Response;

public class RatelimitedHttpClient
extends HttpClient {
    private AtomicInteger requestLimit = new AtomicInteger(0);
    private AtomicInteger requestCount = new AtomicInteger(0);
    private AtomicInteger timeLeft = new AtomicInteger(0);

    public RatelimitedHttpClient(UserAgent userAgent, String apiKey) {
        super(userAgent, apiKey);
    }

    public RatelimitedHttpClient(UserAgent userAgent, String baseUrl, String apiKey) {
        super(userAgent, baseUrl, apiKey);
    }

    @Override
    public CompletableFuture<Void> nextRequest() {
        if (this.requestCount.get() <= 0) {
            return CompletableFuture.runAsync(this::waitLeft);
        }
        this.requestCount.decrementAndGet();
        return CompletableFuture.completedFuture(null);
    }

    private void waitLeft() {
        Thread.sleep(this.timeLeft.get() * 1100 + 1000);
    }

    @Override
    public void interceptResponse(Response response) {
        this.requestLimit.set(Integer.parseInt(response.header("X-Ratelimit-Limit")));
        this.requestCount.set(Integer.parseInt(response.header("X-Ratelimit-Remaining")));
        this.timeLeft.set(Integer.parseInt(response.header("X-Ratelimit-Reset")));
    }
}

