/*
 * Decompiled with CFR 0.152.
 */
package masecla.modrinth4j.endpoints.project.gallery;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import masecla.modrinth4j.client.HttpClient;
import masecla.modrinth4j.endpoints.generic.Endpoint;
import masecla.modrinth4j.endpoints.generic.empty.EmptyResponse;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class CreateGalleryImage
extends Endpoint<EmptyResponse, CreateGalleryImageRequest> {
    public CreateGalleryImage(HttpClient client, Gson gson) {
        super(client, gson);
    }

    @Override
    public String getEndpoint() {
        return "/project/{id}/gallery";
    }

    @Override
    public String getMethod() {
        return "POST";
    }

    @Override
    public CompletableFuture<EmptyResponse> sendRequest(CreateGalleryImageRequest parameters, Map<String, String> urlParams) {
        String url = this.getReplacedUrl(parameters, urlParams);
        String extension = parameters.getFilename().substring(parameters.getFilename().lastIndexOf(".") + 1);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("ext", extension);
        queryParams.put("featured", parameters.isFeatured() + "");
        queryParams.put("title", parameters.getTitle());
        queryParams.put("description", parameters.getDescription());
        return this.getClient().connect(url, queryParams).thenApply(c -> {
            c.method(this.getMethod(), RequestBody.create((byte[])this.readStream(parameters.getImage())));
            c.header("Content-Type", "image/*");
            Response response = this.executeRequest((Request.Builder)c);
            this.checkBodyForErrors(response.body());
            return new EmptyResponse();
        });
    }

    @Override
    public TypeToken<CreateGalleryImageRequest> getRequestClass() {
        return TypeToken.get(CreateGalleryImageRequest.class);
    }

    @Override
    public TypeToken<EmptyResponse> getResponseClass() {
        return TypeToken.get(EmptyResponse.class);
    }

    public static class CreateGalleryImageRequest {
        private String filename;
        private InputStream image;
        private boolean featured;
        private String title;
        private String description;

        @Generated
        CreateGalleryImageRequest(String filename, InputStream image, boolean featured, String title, String description) {
            this.filename = filename;
            this.image = image;
            this.featured = featured;
            this.title = title;
            this.description = description;
        }

        @Generated
        public static CreateGalleryImageRequestBuilder builder() {
            return new CreateGalleryImageRequestBuilder();
        }

        @Generated
        public String getFilename() {
            return this.filename;
        }

        @Generated
        public InputStream getImage() {
            return this.image;
        }

        @Generated
        public boolean isFeatured() {
            return this.featured;
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public void setFilename(String filename) {
            this.filename = filename;
        }

        @Generated
        public void setImage(InputStream image) {
            this.image = image;
        }

        @Generated
        public void setFeatured(boolean featured) {
            this.featured = featured;
        }

        @Generated
        public void setTitle(String title) {
            this.title = title;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateGalleryImageRequest)) {
                return false;
            }
            CreateGalleryImageRequest other = (CreateGalleryImageRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isFeatured() != other.isFeatured()) {
                return false;
            }
            String this$filename = this.getFilename();
            String other$filename = other.getFilename();
            if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
                return false;
            }
            InputStream this$image = this.getImage();
            InputStream other$image = other.getImage();
            if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CreateGalleryImageRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isFeatured() ? 79 : 97);
            String $filename = this.getFilename();
            result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
            InputStream $image = this.getImage();
            result = result * 59 + ($image == null ? 43 : $image.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CreateGalleryImage.CreateGalleryImageRequest(filename=" + this.getFilename() + ", image=" + this.getImage() + ", featured=" + this.isFeatured() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ")";
        }

        public static class CreateGalleryImageRequestBuilder {
            @Generated
            private String filename;
            @Generated
            private InputStream image;
            @Generated
            private boolean featured;
            @Generated
            private String title;
            @Generated
            private String description;

            public CreateGalleryImageRequestBuilder file(File file) {
                this.filename = file.getName();
                this.image = new FileInputStream(file);
                return this;
            }

            @Generated
            CreateGalleryImageRequestBuilder() {
            }

            @Generated
            public CreateGalleryImageRequestBuilder filename(String filename) {
                this.filename = filename;
                return this;
            }

            @Generated
            public CreateGalleryImageRequestBuilder image(InputStream image) {
                this.image = image;
                return this;
            }

            @Generated
            public CreateGalleryImageRequestBuilder featured(boolean featured) {
                this.featured = featured;
                return this;
            }

            @Generated
            public CreateGalleryImageRequestBuilder title(String title) {
                this.title = title;
                return this;
            }

            @Generated
            public CreateGalleryImageRequestBuilder description(String description) {
                this.description = description;
                return this;
            }

            @Generated
            public CreateGalleryImageRequest build() {
                return new CreateGalleryImageRequest(this.filename, this.image, this.featured, this.title, this.description);
            }

            @Generated
            public String toString() {
                return "CreateGalleryImage.CreateGalleryImageRequest.CreateGalleryImageRequestBuilder(filename=" + this.filename + ", image=" + this.image + ", featured=" + this.featured + ", title=" + this.title + ", description=" + this.description + ")";
            }
        }
    }
}

