/*
 * Decompiled with CFR 0.152.
 */
package dev.mauch.spark.excel;

import dev.mauch.spark.excel.DataLocator;
import dev.mauch.spark.excel.ExcelFileSaver$;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.StructField;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import spoiwo.model.Sheet;
import spoiwo.model.Workbook$;
import spoiwo.natures.xlsx.Model2XlsxConversions$;

@ScalaSignature(bytes="\u0006\u0001\u0005]s!\u0002\u000b\u0016\u0011\u0003qb!\u0002\u0011\u0016\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003b\u0002\u0016\u0002\u0005\u0004%)a\u000b\u0005\u0007_\u0005\u0001\u000bQ\u0002\u0017\t\u000fA\n!\u0019!C\u0003c!1Q'\u0001Q\u0001\u000eIBqAN\u0001C\u0002\u0013\u0015q\u0007\u0003\u0004<\u0003\u0001\u0006i\u0001\u000f\u0005\by\u0005\t\n\u0011\"\u0001>\r\u0011\u0001S\u0003A&\t\u00111S!\u0011!Q\u0001\n5C\u0001\u0002\u0017\u0006\u0003\u0002\u0003\u0006I!\u0017\u0005\t9*\u0011\t\u0011)A\u0005;\"A!O\u0003B\u0001B\u0003%1\u000f\u0003\u0005x\u0015\t\u0005\t\u0015!\u0003y\u0011!Y(B!A!\u0002\u0013y\u0004\"\u0002\u0015\u000b\t\u0003a\bbBA\u0005\u0015\u0011\u0005\u00111\u0002\u0005\b\u0003'QA\u0011AA\u000b\u00039)\u0005pY3m\r&dWmU1wKJT!AF\f\u0002\u000b\u0015D8-\u001a7\u000b\u0005aI\u0012!B:qCJ\\'B\u0001\u000e\u001c\u0003\u0015i\u0017-^2i\u0015\u0005a\u0012a\u00013fm\u000e\u0001\u0001CA\u0010\u0002\u001b\u0005)\"AD#yG\u0016dg)\u001b7f'\u00064XM]\n\u0003\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001f\u0003I!UIR!V\u0019R{6\u000bS#F)~s\u0015)T#\u0016\u00031z\u0011!L\u0011\u0002]\u000511\u000b[3fiF\n1\u0003R#G\u0003VcEkX*I\u000b\u0016#vLT!N\u000b\u0002\n1\u0003R#G\u0003VcEk\u0018#B)\u0016{fi\u0014*N\u0003R+\u0012AM\b\u0002g\u0005\nA'A\u0006zs6jW\u0006\u001a\u0011iu5l\u0017\u0001\u0006#F\r\u0006+F\nV0E\u0003R+uLR(S\u001b\u0006#\u0006%\u0001\rE\u000b\u001a\u000bU\u000b\u0014+`)&kUi\u0015+B\u001bB{fi\u0014*N\u0003R+\u0012\u0001O\b\u0002s\u0005\n!(A\fzsfLX&\\7.I\u0012\u0004\u0003\u000e\u001b\u001en[j\u001a8O\f\u00191a\u0005IB)\u0012$B+2#v\fV%N\u000bN#\u0016)\u0014)`\r>\u0013V*\u0011+!\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\taH\u000b\u0002@\u0005B\u00111\u0005Q\u0005\u0003\u0003\u0012\u0012qAQ8pY\u0016\fgnK\u0001D!\t!\u0015*D\u0001F\u0015\t1u)A\u0005v]\u000eDWmY6fI*\u0011\u0001\nJ\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001&F\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\n\u0003\u0015\t\n!AZ:\u0011\u000593V\"A(\u000b\u00051\u0003&BA)S\u0003\u0019A\u0017\rZ8pa*\u00111\u000bV\u0001\u0007CB\f7\r[3\u000b\u0003U\u000b1a\u001c:h\u0013\t9vJ\u0001\u0006GS2,7+_:uK6\f\u0001\u0002\\8dCRLwN\u001c\t\u0003\u001djK!aW(\u0003\tA\u000bG\u000f[\u0001\nI\u0006$\u0018M\u0012:b[\u0016\u0004\"AX8\u000f\u0005}cgB\u00011j\u001d\t\t\u0007N\u0004\u0002cO:\u00111MZ\u0007\u0002I*\u0011Q-H\u0001\u0007yI|w\u000e\u001e \n\u0003UK!a\u0015+\n\u0005a\u0011\u0016B\u00016l\u0003\r\u0019\u0018\u000f\u001c\u0006\u00031IK!!\u001c8\u0002\u000fA\f7m[1hK*\u0011!n[\u0005\u0003aF\u0014\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u00055t\u0017\u0001C:bm\u0016lu\u000eZ3\u0011\u0005Q,X\"\u00018\n\u0005Yt'\u0001C*bm\u0016lu\u000eZ3\u0002\u0017\u0011\fG/\u0019'pG\u0006$xN\u001d\t\u0003?eL!A_\u000b\u0003\u0017\u0011\u000bG/\u0019'pG\u0006$xN]\u0001\u0007Q\u0016\fG-\u001a:\u0015\u0017utx0!\u0001\u0002\u0004\u0005\u0015\u0011q\u0001\t\u0003?)AQ\u0001T\tA\u00025CQ\u0001W\tA\u0002eCQ\u0001X\tA\u0002uCQA]\tA\u0002MDQa^\tA\u0002aDqa_\t\u0011\u0002\u0003\u0007q(\u0001\u0003tCZ,GCAA\u0007!\r\u0019\u0013qB\u0005\u0004\u0003#!#\u0001B+oSR\f\u0011\"Y;u_\u000ecwn]3\u0016\r\u0005]\u0011QHA\u0010)\u0011\tI\"a\u0015\u0015\t\u0005m\u0011\u0011\u0007\t\u0005\u0003;\ty\u0002\u0004\u0001\u0005\u000f\u0005\u00052C1\u0001\u0002$\t\t!)\u0005\u0003\u0002&\u0005-\u0002cA\u0012\u0002(%\u0019\u0011\u0011\u0006\u0013\u0003\u000f9{G\u000f[5oOB\u00191%!\f\n\u0007\u0005=BEA\u0002B]fDq!a\r\u0014\u0001\u0004\t)$A\u0002gk:\u0004raIA\u001c\u0003w\tY\"C\u0002\u0002:\u0011\u0012\u0011BR;oGRLwN\\\u0019\u0011\t\u0005u\u0011Q\b\u0003\b\u0003\u007f\u0019\"\u0019AA!\u0005\u0005\t\u0015\u0003BA\u0013\u0003\u0007\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%\u0001\u0003mC:<'BAA'\u0003\u0011Q\u0017M^1\n\t\u0005E\u0013q\t\u0002\u000e\u0003V$xn\u00117pg\u0016\f'\r\\3\t\u000f\u0005U3\u00031\u0001\u0002<\u0005I1\r\\8tK\u0006\u0014G.\u001a")
public class ExcelFileSaver {
    private final FileSystem fs;
    private final Path location;
    private final Dataset<Row> dataFrame;
    private final SaveMode saveMode;
    private final DataLocator dataLocator;
    private final boolean header;

    public static boolean $lessinit$greater$default$6() {
        return ExcelFileSaver$.MODULE$.$lessinit$greater$default$6();
    }

    public static String DEFAULT_TIMESTAMP_FORMAT() {
        return ExcelFileSaver$.MODULE$.DEFAULT_TIMESTAMP_FORMAT();
    }

    public static String DEFAULT_DATE_FORMAT() {
        return ExcelFileSaver$.MODULE$.DEFAULT_DATE_FORMAT();
    }

    public static String DEFAULT_SHEET_NAME() {
        return ExcelFileSaver$.MODULE$.DEFAULT_SHEET_NAME();
    }

    public void save() {
        SaveMode saveMode;
        boolean bl;
        boolean fileAlreadyExists = this.fs.exists(this.location);
        Tuple2<Boolean, SaveMode> tuple2 = new Tuple2<Boolean, SaveMode>(BoxesRunTime.boxToBoolean(fileAlreadyExists), this.saveMode);
        if (tuple2 != null && false == (bl = tuple2._1$mcZ$sp()) ? true : tuple2 != null && SaveMode.Overwrite.equals(saveMode = tuple2._2())) {
            Serializable serializable = fileAlreadyExists ? BoxesRunTime.boxToBoolean(this.fs.delete(this.location, true)) : BoxedUnit.UNIT;
            this.writeToWorkbook$1(new XSSFWorkbook());
            return;
        }
        if (tuple2 != null) {
            boolean bl2 = tuple2._1$mcZ$sp();
            SaveMode saveMode2 = tuple2._2();
            if (bl2 && SaveMode.ErrorIfExists.equals(saveMode2)) {
                throw package$.MODULE$.error(new StringBuilder(21).append("path ").append(this.location).append(" already exists.").toString());
            }
        }
        if (tuple2 != null) {
            boolean bl3 = tuple2._1$mcZ$sp();
            SaveMode saveMode3 = tuple2._2();
            if (bl3 && SaveMode.Ignore.equals(saveMode3)) {
                return;
            }
        }
        if (tuple2 != null) {
            boolean bl4 = tuple2._1$mcZ$sp();
            SaveMode saveMode4 = tuple2._2();
            if (bl4 && SaveMode.Append.equals(saveMode4)) {
                FSDataInputStream inputStream = this.fs.open(this.location);
                XSSFWorkbook workbook = new XSSFWorkbook((InputStream)inputStream);
                inputStream.close();
                this.writeToWorkbook$1(workbook);
                return;
            }
        }
        throw new MatchError(tuple2);
    }

    public <A extends AutoCloseable, B> B autoClose(A closeable, Function1<A, B> fun) {
        B b;
        try {
            b = fun.apply(closeable);
        }
        finally {
            closeable.close();
        }
        return b;
    }

    private final Sheet sheet$1(XSSFWorkbook workbook) {
        Option headerRow = this.header ? new Some<GenSeq>(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])this.dataFrame.schema().fields())).map((Function1<StructField, String> & Serializable & scala.Serializable)x$1 -> x$1.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq()) : None$.MODULE$;
        Iterator<Seq<Object>> dataRows = CollectionConverters$.MODULE$.asScalaIteratorConverter(this.dataFrame.toLocalIterator()).asScala().map((Function1<Row, Seq> & Serializable & scala.Serializable)x$2 -> x$2.toSeq());
        return this.dataLocator.toSheet(headerRow, dataRows, workbook);
    }

    private final void writeToWorkbook$1(XSSFWorkbook workbook) {
        Model2XlsxConversions$.MODULE$.XlsxWorkbook(Workbook$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Sheet[]{this.sheet$1(workbook)}))).writeToExisting(workbook);
        this.autoClose(new BufferedOutputStream((OutputStream)this.fs.create(this.location)), (Function1<OutputStream, Object> & Serializable & scala.Serializable)x$1 -> {
            workbook.write(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public ExcelFileSaver(FileSystem fs, Path location, Dataset<Row> dataFrame, SaveMode saveMode, DataLocator dataLocator, boolean header) {
        this.fs = fs;
        this.location = location;
        this.dataFrame = dataFrame;
        this.saveMode = saveMode;
        this.dataLocator = dataLocator;
        this.header = header;
    }
}

