/*
 * Decompiled with CFR 0.152.
 */
package dev.mauch.spark.excel.v2;

import dev.mauch.spark.excel.v2.ExcelHelper$;
import dev.mauch.spark.excel.v2.ExcelOptions;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0012%\u0001=B\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005q!AA\t\u0001BC\u0002\u0013\u0005Q\t\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003G\u0011!!\u0006A!b\u0001\n\u0003)\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011y\u0003!Q1A\u0005\u0002}C\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\u0006K\u0002!\tA\u001a\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u0019A\b\u0001)A\u0005]\"Q\u0011\u0010\u0001I\u0001\u0002\u0007\u0005\u000b\u0011\u0002>\t\u0013\u0005\u001d\u0001A1A\u0005\n\u0005%\u0001bBA\u0006\u0001\u0001\u0006I! \u0005\n\u0003\u001b\u0001!\u0019!C\u0005\u0003\u001fA\u0001\"!\u0005\u0001A\u0003%\u0011\u0011\u0001\u0005\n\u0003'\u0001!\u0019!C\u0005\u0003\u001fA\u0001\"!\u0006\u0001A\u0003%\u0011\u0011A\u0003\u0007\u0003/\u0001A!!\u0007\t\u0013\u0005]\u0002A1A\u0005\n\u0005e\u0002\u0002CA#\u0001\u0001\u0006I!a\u000f\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J!Q\u0011Q\u000b\u0001\t\u0006\u0004%I!a\u0016\t\u0015\u0005e\u0003\u0001#b\u0001\n\u0013\t9\u0006\u0003\u0006\u0002\\\u0001A)\u0019!C\u0005\u0003/B!\"!\u0018\u0001\u0011\u000b\u0007I\u0011BA,\u0011)\ty\u0006\u0001EC\u0002\u0013%\u0011q\u000b\u0005\b\u0003C\u0002A\u0011BA2\u0011%\ty\u0007\u0001a\u0001\n\u0013\ty\u0001C\u0005\u0002r\u0001\u0001\r\u0011\"\u0003\u0002t!A\u0011q\u000f\u0001!B\u0013\t\t\u0001C\u0004\u0002z\u0001!\t!a\u001f\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000!9\u0011Q\u0011\u0001\u0005\u0002\u0005m$AD#yG\u0016dw)\u001a8fe\u0006$xN\u001d\u0006\u0003K\u0019\n!A\u001e\u001a\u000b\u0005\u001dB\u0013!B3yG\u0016d'BA\u0015+\u0003\u0015\u0019\b/\u0019:l\u0015\tYC&A\u0003nCV\u001c\u0007NC\u0001.\u0003\r!WM^\u0002\u0001'\t\u0001\u0001\u0007\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$G\u0001\u0004B]f\u0014VMZ\u0001\u0005a\u0006$\b.F\u00019!\tI\u0004I\u0004\u0002;}A\u00111HM\u0007\u0002y)\u0011QHL\u0001\u0007yI|w\u000e\u001e \n\u0005}\u0012\u0014A\u0002)sK\u0012,g-\u0003\u0002B\u0005\n11\u000b\u001e:j]\u001eT!a\u0010\u001a\u0002\u000bA\fG\u000f\u001b\u0011\u0002\u0015\u0011\fG/Y*dQ\u0016l\u0017-F\u0001G!\t9\u0015+D\u0001I\u0015\tI%*A\u0003usB,7O\u0003\u0002L\u0019\u0006\u00191/\u001d7\u000b\u0005%j%B\u0001(P\u0003\u0019\t\u0007/Y2iK*\t\u0001+A\u0002pe\u001eL!A\u0015%\u0003\u0015M#(/^2u)f\u0004X-A\u0006eCR\f7k\u00195f[\u0006\u0004\u0013\u0001B2p]\u001a,\u0012A\u0016\t\u0003/nk\u0011\u0001\u0017\u0006\u0003)fS!AW'\u0002\r!\fGm\\8q\u0013\ta\u0006LA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0006G>tg\rI\u0001\b_B$\u0018n\u001c8t+\u0005\u0001\u0007CA1c\u001b\u0005!\u0013BA2%\u00051)\u0005pY3m\u001fB$\u0018n\u001c8t\u0003!y\u0007\u000f^5p]N\u0004\u0013A\u0002\u001fj]&$h\bF\u0003hQ&T7\u000e\u0005\u0002b\u0001!)a'\u0003a\u0001q!)A)\u0003a\u0001\r\")A+\u0003a\u0001-\")a,\u0003a\u0001A\u0006\u0011qOY\u000b\u0002]B\u0011qN^\u0007\u0002a*\u0011\u0011O]\u0001\nkN,'/\\8eK2T!a\u001d;\u0002\u0005M\u001c(BA;N\u0003\r\u0001x.[\u0005\u0003oB\u0014\u0001bV8sW\n|wn[\u0001\u0004o\n\u0004\u0013a\u0001=%cA9\u0011g_?\u0002\u0002\u0005\u0005\u0011B\u0001?3\u0005\u0019!V\u000f\u001d7fgA\u0011qN`\u0005\u0003\u007fB\u0014Qa\u00155fKR\u00042!MA\u0002\u0013\r\t)A\r\u0002\u0004\u0013:$\u0018!B:iK\u0016$X#A?\u0002\rMDW-\u001a;!\u0003!1\u0017N]:u\u0007>dWCAA\u0001\u0003%1\u0017N]:u\u0007>d\u0007%\u0001\u0005gSJ\u001cHOU8x\u0003%1\u0017N]:u%><\bE\u0001\bWC2,XmQ8om\u0016\u0014H/\u001a:\u0011\u0017E\nY\"a\b\u0002\u0002\u0005-\u0012\u0011G\u0005\u0004\u0003;\u0011$!\u0003$v]\u000e$\u0018n\u001c84!\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013\u0015\u0006A1-\u0019;bYf\u001cH/\u0003\u0003\u0002*\u0005\r\"aC%oi\u0016\u0014h.\u00197S_^\u00042a\\A\u0017\u0013\r\ty\u0003\u001d\u0002\u0005\u0007\u0016dG\u000eE\u00022\u0003gI1!!\u000e3\u0005\u0011)f.\u001b;\u0002\u001fY\fG.^3D_:4XM\u001d;feN,\"!a\u000f\u0011\u000bE\ni$!\u0011\n\u0007\u0005}\"GA\u0003BeJ\f\u0017\u0010E\u0002\u0002DMi\u0011\u0001A\u0001\u0011m\u0006dW/Z\"p]Z,'\u000f^3sg\u0002\n1b\u0019:fCR,7\u000b^=mKR!\u00111JA)!\ry\u0017QJ\u0005\u0004\u0003\u001f\u0002(!C\"fY2\u001cF/\u001f7f\u0011\u0019\t\u0019F\u0006a\u0001q\u00051am\u001c:nCR\fQ\u0002R1uK\u000e+G\u000e\\*us2,WCAA&\u0003I!\u0016.\\3ti\u0006l\u0007oQ3mYN#\u0018\u0010\\3\u0002)]Cw\u000e\\3Ok6\u0014WM]\"fY2\u001cF/\u001f7f\u0003Y!UmY5nC2tU/\u001c2fe\u000e+G\u000e\\*us2,\u0017aD*ue&twmQ3mYN#\u0018\u0010\\3\u0002\u001b5\f7.Z\"p]Z,'\u000f^3s)\u0011\t\t%!\u001a\t\u000f\u0005\u001dD\u00041\u0001\u0002j\u0005AA-\u0019;b)f\u0004X\rE\u0002H\u0003WJ1!!\u001cI\u0005!!\u0015\r^1UsB,\u0017a\u0001:po\u00069!o\\<`I\u0015\fH\u0003BA\u0019\u0003kB\u0001\"\u001f\u0010\u0002\u0002\u0003\u0007\u0011\u0011A\u0001\u0005e><\b%\u0001\u0007xe&$X\rS3bI\u0016\u00148\u000f\u0006\u0002\u00022\u0005)qO]5uKR!\u0011\u0011GAA\u0011\u001d\t\u0019)\ta\u0001\u0003?\taA]3d_J$\u0017!B2m_N,\u0007")
public class ExcelGenerator {
    private CellStyle DateCellStyle;
    private CellStyle TimestampCellStyle;
    private CellStyle WholeNumberCellStyle;
    private CellStyle DecimalNumberCellStyle;
    private CellStyle StringCellStyle;
    private final String path;
    private final StructType dataSchema;
    private final Configuration conf;
    private final ExcelOptions options;
    private final Workbook wb;
    private final /* synthetic */ Tuple3 x$1;
    private final Sheet sheet;
    private final int firstCol;
    private final int firstRow;
    private final Function3<InternalRow, Object, Cell, BoxedUnit>[] valueConverters;
    private int row;
    private volatile byte bitmap$0;

    public String path() {
        return this.path;
    }

    public StructType dataSchema() {
        return this.dataSchema;
    }

    public Configuration conf() {
        return this.conf;
    }

    public ExcelOptions options() {
        return this.options;
    }

    private Workbook wb() {
        return this.wb;
    }

    private Sheet sheet() {
        return this.sheet;
    }

    private int firstCol() {
        return this.firstCol;
    }

    private int firstRow() {
        return this.firstRow;
    }

    private Function3<InternalRow, Object, Cell, BoxedUnit>[] valueConverters() {
        return this.valueConverters;
    }

    private CellStyle createStyle(String format) {
        CreationHelper createHelper = this.wb().getCreationHelper();
        CellStyle r = this.wb().createCellStyle();
        r.setDataFormat(createHelper.createDataFormat().getFormat(format));
        return r;
    }

    private CellStyle DateCellStyle$lzycompute() {
        ExcelGenerator excelGenerator = this;
        synchronized (excelGenerator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.DateCellStyle = this.createStyle(this.options().dateFormat());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.DateCellStyle;
    }

    private CellStyle DateCellStyle() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.DateCellStyle$lzycompute();
        }
        return this.DateCellStyle;
    }

    private CellStyle TimestampCellStyle$lzycompute() {
        ExcelGenerator excelGenerator = this;
        synchronized (excelGenerator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.TimestampCellStyle = this.createStyle(this.options().timestampFormat());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.TimestampCellStyle;
    }

    private CellStyle TimestampCellStyle() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.TimestampCellStyle$lzycompute();
        }
        return this.TimestampCellStyle;
    }

    private CellStyle WholeNumberCellStyle$lzycompute() {
        ExcelGenerator excelGenerator = this;
        synchronized (excelGenerator) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.WholeNumberCellStyle = this.createStyle("General");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.WholeNumberCellStyle;
    }

    private CellStyle WholeNumberCellStyle() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.WholeNumberCellStyle$lzycompute();
        }
        return this.WholeNumberCellStyle;
    }

    private CellStyle DecimalNumberCellStyle$lzycompute() {
        ExcelGenerator excelGenerator = this;
        synchronized (excelGenerator) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.DecimalNumberCellStyle = this.options().usePlainNumberFormat() ? this.createStyle("General") : this.createStyle("0.00E+000");
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.DecimalNumberCellStyle;
    }

    private CellStyle DecimalNumberCellStyle() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.DecimalNumberCellStyle$lzycompute();
        }
        return this.DecimalNumberCellStyle;
    }

    private CellStyle StringCellStyle$lzycompute() {
        ExcelGenerator excelGenerator = this;
        synchronized (excelGenerator) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.StringCellStyle = this.createStyle("@");
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.StringCellStyle;
    }

    private CellStyle StringCellStyle() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.StringCellStyle$lzycompute();
        }
        return this.StringCellStyle;
    }

    private Function3<InternalRow, Object, Cell, BoxedUnit> makeConverter(DataType dataType) {
        DataType dataType2 = dataType;
        if (ByteType$.MODULE$.equals(dataType2)) {
            return (Function3<InternalRow, Object, Cell, Object> & Serializable & scala.Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$1(this, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        if (ShortType$.MODULE$.equals(dataType2)) {
            return (Function3<InternalRow, Object, Cell, Object> & Serializable & scala.Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$2(this, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            return (Function3<InternalRow, Object, Cell, Object> & Serializable & scala.Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$3(this, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            return (Function3<InternalRow, Object, Cell, Object> & Serializable & scala.Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$4(this, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            return (Function3<InternalRow, Object, Cell, Object> & Serializable & scala.Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$5(this, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            return (Function3<InternalRow, Object, Cell, Object> & Serializable & scala.Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$6(this, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            return (Function3<InternalRow, Object, Cell, Object> & Serializable & scala.Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$7(this, decimalType, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        if (DateType$.MODULE$.equals(dataType2)) {
            return (Function3<InternalRow, Object, Cell, Object> & Serializable & scala.Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$8(this, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        if (TimestampType$.MODULE$.equals(dataType2)) {
            return (Function3<InternalRow, Object, Cell, Object> & Serializable & scala.Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$9(this, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        if (StringType$.MODULE$.equals(dataType2)) {
            return (Function3<InternalRow, Object, Cell, Object> & Serializable & scala.Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$10(this, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        if (BooleanType$.MODULE$.equals(dataType2)) {
            return (Function3<InternalRow, Object, Cell, Object> & Serializable & scala.Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$11(this, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        throw new RuntimeException(new StringBuilder(18).append("Unsupported type: ").append(dataType.typeName()).toString());
    }

    private int row() {
        return this.row;
    }

    private void row_$eq(int x$1) {
        this.row = x$1;
    }

    public void writeHeaders() {
        Row excelRow = this.sheet().createRow(this.row());
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])this.dataSchema().fields())).map((Function1<StructField, String> & Serializable & scala.Serializable)x$3 -> x$3.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
            ExcelGenerator.$anonfun$writeHeaders$2(this, excelRow, x0$1);
            return BoxedUnit.UNIT;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
        this.row_$eq(this.row() + 1);
    }

    public void write(InternalRow record) {
        Row excelRow = this.sheet().createRow(this.row());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), record.numFields()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)idx -> {
            Cell cell = excelRow.createCell(idx + this.firstCol());
            if (record.isNullAt(idx)) {
                cell.setBlank();
                return;
            }
            this.valueConverters()[idx].apply(record, BoxesRunTime.boxToInteger(idx), cell);
        });
        this.row_$eq(this.row() + 1);
    }

    public void close() {
        Path hdfsPath = new Path(this.path());
        FileSystem fs = hdfsPath.getFileSystem(this.conf());
        FSDataOutputStream fos = fs.create(hdfsPath, true);
        this.wb().write((OutputStream)fos);
        this.wb().close();
        fos.close();
    }

    public static final /* synthetic */ void $anonfun$makeConverter$1(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getByte(ordinal));
        cell.setCellStyle($this.WholeNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$2(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getShort(ordinal));
        cell.setCellStyle($this.WholeNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$3(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getInt(ordinal));
        cell.setCellStyle($this.WholeNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$4(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getLong(ordinal));
        cell.setCellStyle($this.WholeNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$5(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getFloat(ordinal));
        cell.setCellStyle($this.DecimalNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$6(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getDouble(ordinal));
        cell.setCellStyle($this.DecimalNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$7(ExcelGenerator $this, DecimalType x8$1, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getDecimal(ordinal, x8$1.precision(), x8$1.scale()).toDouble());
        cell.setCellStyle($this.DecimalNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$8(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(DateTimeUtils$.MODULE$.toJavaDate(row.getInt(ordinal)));
        cell.setCellStyle($this.DateCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$9(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(DateTimeUtils$.MODULE$.toJavaTimestamp(row.getLong(ordinal)));
        cell.setCellStyle($this.TimestampCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$10(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getString(ordinal));
        cell.setCellStyle($this.StringCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$11(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getBoolean(ordinal));
        cell.setCellStyle($this.WholeNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$writeHeaders$2(ExcelGenerator $this, Row excelRow$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            excelRow$1.createCell(idx + $this.firstCol()).setCellValue(name);
            return;
        }
        throw new MatchError(tuple2);
    }

    public ExcelGenerator(String path, StructType dataSchema, Configuration conf, ExcelOptions options) {
        Workbook workbook;
        this.path = path;
        this.dataSchema = dataSchema;
        this.conf = conf;
        this.options = options;
        String string = options.fileExtension().toLowerCase();
        String string2 = "xlsx";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Option<Object> option = options.maxRowsInMemory();
            if (option instanceof Some) {
                Some some = (Some)option;
                int maxRows = BoxesRunTime.unboxToInt(some.value());
                workbook = new SXSSFWorkbook(maxRows);
            } else {
                workbook = new XSSFWorkbook();
            }
        } else {
            workbook = new HSSFWorkbook();
        }
        this.wb = workbook;
        AreaReference dataAddress = ExcelHelper$.MODULE$.apply(options).parsedRangeAddress();
        String ret = dataAddress.getFirstCell().getSheetName();
        String sheetname = ret == null || ret.isEmpty() ? "Sheet1" : WorkbookUtil.createSafeSheetName(ret);
        short col = dataAddress.getFirstCell().getCol();
        int row = dataAddress.getFirstCell().getRow();
        Tuple3<Sheet, Integer, Integer> tuple3 = new Tuple3<Sheet, Integer, Integer>(this.wb().createSheet(sheetname), BoxesRunTime.boxToInteger(col), BoxesRunTime.boxToInteger(row));
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Sheet sheet = tuple3._1();
        int firstCol = BoxesRunTime.unboxToInt(tuple3._2());
        int firstRow = BoxesRunTime.unboxToInt(tuple3._3());
        this.x$1 = new Tuple3<Sheet, Integer, Integer>(sheet, BoxesRunTime.boxToInteger(firstCol), BoxesRunTime.boxToInteger(firstRow));
        this.sheet = (Sheet)this.x$1._1();
        this.firstCol = BoxesRunTime.unboxToInt(this.x$1._2());
        this.firstRow = BoxesRunTime.unboxToInt(this.x$1._3());
        this.valueConverters = (Function3[])((TraversableOnce)((TraversableLike)dataSchema.map((Function1<StructField, DataType> & Serializable & scala.Serializable)x$2 -> x$2.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1<DataType, Function3> & Serializable & scala.Serializable)dataType -> this.makeConverter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function3.class));
        this.row = this.firstRow();
    }
}

