/*
 * Decompiled with CFR 0.152.
 */
package dev.mauch.spark.excel.v2;

import dev.mauch.spark.excel.v2.ExcelOptions;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00014AAC\u0006\u0001-!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u0011!1\u0004A!A!\u0002\u00139\u0004\"\u0002\"\u0001\t\u0003\u0019\u0005b\u0002%\u0001\u0005\u0004%I!\u0013\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002&\t\u000f9\u0003!\u0019!C\u0005\u0013\"1q\n\u0001Q\u0001\n)CQ\u0001\u0015\u0001\u0005\u0002E\u0013!#\u0012=dK2DU-\u00193fe\u000eCWmY6fe*\u0011A\"D\u0001\u0003mJR!AD\b\u0002\u000b\u0015D8-\u001a7\u000b\u0005A\t\u0012!B:qCJ\\'B\u0001\n\u0014\u0003\u0015i\u0017-^2i\u0015\u0005!\u0012a\u00013fm\u000e\u00011c\u0001\u0001\u0018;A\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\u0004\"A\b\u0014\u000e\u0003}Q!\u0001I\u0011\u0002\u0011%tG/\u001a:oC2T!\u0001\u0005\u0012\u000b\u0005\r\"\u0013AB1qC\u000eDWMC\u0001&\u0003\ry'oZ\u0005\u0003O}\u0011q\u0001T8hO&tw-\u0001\u0004tG\",W.\u0019\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nQ\u0001^=qKNT!AL\u0011\u0002\u0007M\fH.\u0003\u00021W\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u000f=\u0004H/[8ogB\u00111\u0007N\u0007\u0002\u0017%\u0011Qg\u0003\u0002\r\u000bb\u001cW\r\\(qi&|gn]\u0001\u0007g>,(oY3\u0011\u0005azdBA\u001d>!\tQ\u0014$D\u0001<\u0015\taT#\u0001\u0004=e>|GOP\u0005\u0003}e\ta\u0001\u0015:fI\u00164\u0017B\u0001!B\u0005\u0019\u0019FO]5oO*\u0011a(G\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0011+ei\u0012\t\u0003g\u0001AQ\u0001\u000b\u0003A\u0002%BQ!\r\u0003A\u0002IBQA\u000e\u0003A\u0002]\nQbY1tKN+gn]5uSZ,W#\u0001&\u0011\u0005aY\u0015B\u0001'\u001a\u0005\u001d\u0011un\u001c7fC:\fabY1tKN+gn]5uSZ,\u0007%A\u0007f]\u001a|'oY3TG\",W.Y\u0001\u000fK:4wN]2f'\u000eDW-\\1!\u0003Y\u0019\u0007.Z2l\u0011\u0016\fG-\u001a:D_2,XN\u001c(b[\u0016\u001cHC\u0001*V!\tA2+\u0003\u0002U3\t!QK\\5u\u0011\u00151\u0016\u00021\u0001X\u0003-\u0019w\u000e\\;n]:\u000bW.Z:\u0011\u0007akvG\u0004\u0002Z7:\u0011!HW\u0005\u00025%\u0011A,G\u0001\ba\u0006\u001c7.Y4f\u0013\tqvL\u0001\u0004WK\u000e$xN\u001d\u0006\u00039f\u0001")
public class ExcelHeaderChecker
implements Logging {
    private final StructType schema;
    private final String source;
    private final boolean caseSensitive;
    private final boolean enforceSchema;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private boolean caseSensitive() {
        return this.caseSensitive;
    }

    private boolean enforceSchema() {
        return this.enforceSchema;
    }

    public void checkHeaderColumnNames(Vector<String> columnNames) {
        if (columnNames != null) {
            IndexedSeq fieldNames = ((TraversableOnce)this.schema.map((Function1<StructField, String> & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom())).toIndexedSeq();
            Tuple2$mcII$sp tuple2$mcII$sp = new Tuple2$mcII$sp(columnNames.size(), fieldNames.length());
            if (tuple2$mcII$sp == null) {
                throw new MatchError(tuple2$mcII$sp);
            }
            int headerLen = ((Tuple2)tuple2$mcII$sp)._1$mcI$sp();
            int schemaSize = ((Tuple2)tuple2$mcII$sp)._2$mcI$sp();
            Tuple2$mcII$sp tuple2$mcII$sp2 = new Tuple2$mcII$sp(headerLen, schemaSize);
            int headerLen2 = ((Tuple2)tuple2$mcII$sp2)._1$mcI$sp();
            int schemaSize2 = ((Tuple2)tuple2$mcII$sp2)._2$mcI$sp();
            Option errorMessage = None$.MODULE$;
            if (headerLen2 == schemaSize2) {
                for (int i = 0; ((Option)errorMessage).isEmpty() && i < headerLen2; ++i) {
                    Tuple2 tuple2 = new Tuple2(fieldNames.apply(i), columnNames.apply(i));
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    String nameInSchema = (String)tuple2._1();
                    String nameInHeader = tuple2._2();
                    Tuple2<String, String> tuple22 = new Tuple2<String, String>(nameInSchema, nameInHeader);
                    String nameInSchema2 = tuple22._1();
                    String nameInHeader2 = tuple22._2();
                    if (!this.caseSensitive()) {
                        nameInSchema2 = nameInSchema2.toLowerCase();
                        nameInHeader2 = nameInHeader2.toLowerCase();
                    }
                    String string = nameInHeader2;
                    String string2 = nameInSchema2;
                    if (!(string == null ? string2 != null : !string.equals(string2))) continue;
                    errorMessage = new Some<String>(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(165).append("|Excel header does not conform to the schema.\n                  | Header: ").append(columnNames.mkString(", ")).append("\n                  | Schema: ").append(fieldNames.mkString(", ")).append("\n                  |Expected: ").append(fieldNames.apply(i)).append(" but found: ").append((Object)columnNames.apply(i)).append("\n                  |").append(this.source).toString())).stripMargin());
                }
            } else {
                errorMessage = new Some<String>(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(144).append("|Number of column in Excel header is not equal to number of fields in the schema:\n              | Header length: ").append(headerLen2).append(", schema size: ").append(schemaSize2).append("\n              |").append(this.source).toString())).stripMargin());
            }
            errorMessage.foreach((Function1<String, Object> & Serializable & scala.Serializable)msg -> {
                ExcelHeaderChecker.$anonfun$checkHeaderColumnNames$2(this, msg);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$checkHeaderColumnNames$2(ExcelHeaderChecker $this, String msg) {
        if ($this.enforceSchema()) {
            $this.logWarning((Function0<String> & Serializable & scala.Serializable)() -> msg);
            return;
        }
        throw new IllegalArgumentException(msg);
    }

    public ExcelHeaderChecker(StructType schema, ExcelOptions options, String source) {
        this.schema = schema;
        this.source = source;
        Logging.$init$((Logging)this);
        this.caseSensitive = SQLConf$.MODULE$.get().caseSensitiveAnalysis();
        this.enforceSchema = options.enforceSchema();
    }
}

