/*
 * Decompiled with CFR 0.152.
 */
package dev.mauch.spark.excel.v2;

import com.github.pjfanning.xlsx.StreamingReader;
import dev.mauch.spark.excel.v2.DataLocator;
import dev.mauch.spark.excel.v2.DataLocator$;
import dev.mauch.spark.excel.v2.ExcelHelper$;
import dev.mauch.spark.excel.v2.ExcelOptions;
import dev.mauch.spark.excel.v2.PlainNumberFormat$;
import dev.mauch.spark.excel.v2.SheetData;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellReference;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1$mcVI$sp;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\n\u0015\u0001}A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\u0006W\u0001!I\u0001\f\u0005\t_\u0001A)\u0019!C\u0005a!)q\b\u0001C\u0001\u0001\")\u0011\u000b\u0001C\u0001%\")\u0011\u000e\u0001C\u0001U\")\u0011\u0010\u0001C\u0001u\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\n\u0001\u0011\u0005\u0011QC\u0004\b\u0003G!\u0002\u0012AA\u0013\r\u0019\u0019B\u0003#\u0001\u0002(!11f\u0003C\u0001\u0003SA\u0011\"a\u000b\f\u0005\u0004%I!!\f\t\u0011\u0005\u00053\u0002)A\u0005\u0003_A\u0011\"a\u0011\f\u0005\u0004%I!!\f\t\u0011\u0005\u00153\u0002)A\u0005\u0003_Aq!a\u0012\f\t\u0003\tI\u0005C\u0004\u0002N-!\t!a\u0014\u0003\u0017\u0015C8-\u001a7IK2\u0004XM\u001d\u0006\u0003+Y\t!A\u001e\u001a\u000b\u0005]A\u0012!B3yG\u0016d'BA\r\u001b\u0003\u0015\u0019\b/\u0019:l\u0015\tYB$A\u0003nCV\u001c\u0007NC\u0001\u001e\u0003\r!WM^\u0002\u0001'\t\u0001\u0001\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VMZ\u0001\b_B$\u0018n\u001c8t!\tA\u0013&D\u0001\u0015\u0013\tQCC\u0001\u0007Fq\u000e,Gn\u00149uS>t7/\u0001\u0004=S:LGO\u0010\u000b\u0003[9\u0002\"\u0001\u000b\u0001\t\u000b\u0019\u0012\u0001\u0019A\u0014\u0002\u001b\u0011\fG/\u0019$pe6\fG\u000f^3s+\u0005\t\u0004C\u0001\u001a>\u001b\u0005\u0019$B\u0001\u001b6\u0003%)8/\u001a:n_\u0012,GN\u0003\u00027o\u0005\u00111o\u001d\u0006\u0003qe\n1\u0001]8j\u0015\tQ4(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002y\u0005\u0019qN]4\n\u0005y\u001a$!\u0004#bi\u00064uN]7biR,'/A\ntC\u001a,7)\u001a7m'R\u0014\u0018N\\4WC2,X\r\u0006\u0002B\u0019B\u0011!)\u0013\b\u0003\u0007\u001e\u0003\"\u0001\u0012\u0012\u000e\u0003\u0015S!A\u0012\u0010\u0002\rq\u0012xn\u001c;?\u0013\tA%%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0015.\u0013aa\u0015;sS:<'B\u0001%#\u0011\u0015iE\u00011\u0001O\u0003\u0011\u0019W\r\u001c7\u0011\u0005Iz\u0015B\u0001)4\u0005\u0011\u0019U\r\u001c7\u0002\u0017\u001d,GoV8sW\n|wn\u001b\u000b\u0004'Z{\u0006C\u0001\u001aU\u0013\t)6G\u0001\u0005X_J\\'m\\8l\u0011\u00159V\u00011\u0001Y\u0003\u0011\u0019wN\u001c4\u0011\u0005ekV\"\u0001.\u000b\u0005][&B\u0001/:\u0003\u0019A\u0017\rZ8pa&\u0011aL\u0017\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000b\u0001,\u0001\u0019A1\u0002\u0007U\u0014\u0018\u000e\u0005\u0002cO6\t1M\u0003\u0002eK\u0006\u0019a.\u001a;\u000b\u0003\u0019\fAA[1wC&\u0011\u0001n\u0019\u0002\u0004+JK\u0015\u0001D4fiNCW-\u001a;ECR\fGcA6xqB\u0019\u0001\u0006\u001c8\n\u00055$\"!C*iK\u0016$H)\u0019;b!\ryGO\u0014\b\u0003aJt!\u0001R9\n\u0003\rJ!a\u001d\u0012\u0002\u000fA\f7m[1hK&\u0011QO\u001e\u0002\u0007-\u0016\u001cGo\u001c:\u000b\u0005M\u0014\u0003\"B,\u0007\u0001\u0004A\u0006\"\u00021\u0007\u0001\u0004\t\u0017A\u00049beN,7\u000b[3fi\u0012\u000bG/\u0019\u000b\u0005w~\f\t\u0001\u0005\u0003\"y.t\u0018BA?#\u0005\u0019!V\u000f\u001d7feA\u0019q\u000e^!\t\u000b];\u0001\u0019\u0001-\t\u000f\u0005\rq\u00011\u0001\u0002\u0006\u0005!QO]5t!\u0011y\u0017qA1\n\u0007\u0005%aOA\u0002TKF\fabZ3u\u0007>dW/\u001c8OC6,7\u000fF\u0002\u007f\u0003\u001fAa!!\u0005\t\u0001\u0004q\u0017\u0001\u00034jeN$(k\\<\u0002%A\f'o]3e%\u0006tw-Z!eIJ,7o\u001d\u000b\u0003\u0003/\u0001B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;)\u0014\u0001B;uS2LA!!\t\u0002\u001c\ti\u0011I]3b%\u00164WM]3oG\u0016\f1\"\u0012=dK2DU\r\u001c9feB\u0011\u0001fC\n\u0003\u0017\u0001\"\"!!\n\u0002'\r|gNZ5hkJ\fG/[8o\u001d\u0016,G-\u001a3\u0016\u0005\u0005=\u0002\u0003BA\u0019\u0003{i!!a\r\u000b\t\u0005U\u0012qG\u0001\u0007CR|W.[2\u000b\t\u0005e\u00121H\u0001\u000bG>t7-\u001e:sK:$(bAA\u000fK&!\u0011qHA\u001a\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006!2m\u001c8gS\u001e,(/\u0019;j_:tU-\u001a3fI\u0002\n1cY8oM&<WO]1uS>t\u0017j\u001d#p]\u0016\fAcY8oM&<WO]1uS>t\u0017j\u001d#p]\u0016\u0004\u0013!B1qa2LHcA\u0017\u0002L!)a%\u0005a\u0001O\u000512m\u001c8gS\u001e,(/\u001a)s_ZLG-\u001a:t\u001f:\u001cW\r\u0006\u0002\u0002RA\u0019\u0011%a\u0015\n\u0007\u0005U#E\u0001\u0003V]&$\b")
public class ExcelHelper {
    private DataFormatter dataFormatter;
    private final ExcelOptions options;
    private volatile boolean bitmap$0;

    public static void configureProvidersOnce() {
        ExcelHelper$.MODULE$.configureProvidersOnce();
    }

    public static ExcelHelper apply(ExcelOptions excelOptions) {
        return ExcelHelper$.MODULE$.apply(excelOptions);
    }

    /*
     * WARNING - void declaration
     */
    private DataFormatter dataFormatter$lzycompute() {
        ExcelHelper excelHelper = this;
        synchronized (excelHelper) {
            if (!this.bitmap$0) {
                void var2_2;
                DataFormatter r = new DataFormatter();
                if (this.options.usePlainNumberFormat()) {
                    PlainNumberFormat$ plainNumberFormat = PlainNumberFormat$.MODULE$;
                    r.addFormat("General", plainNumberFormat);
                    r.addFormat("@", plainNumberFormat);
                }
                this.dataFormatter = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.dataFormatter;
    }

    private DataFormatter dataFormatter() {
        if (!this.bitmap$0) {
            return this.dataFormatter$lzycompute();
        }
        return this.dataFormatter;
    }

    public String safeCellStringValue(Cell cell) {
        CellType cellType = cell.getCellType();
        if (((Object)((Object)CellType.BLANK)).equals((Object)cellType) ? true : ((Object)((Object)CellType._NONE)).equals((Object)cellType)) {
            return "";
        }
        if (((Object)((Object)CellType.STRING)).equals((Object)cellType)) {
            return cell.getStringCellValue();
        }
        if (((Object)((Object)CellType.FORMULA)).equals((Object)cellType)) {
            CellType cellType2 = cell.getCachedFormulaResultType();
            if (((Object)((Object)CellType.BLANK)).equals((Object)cellType2) ? true : ((Object)((Object)CellType._NONE)).equals((Object)cellType2)) {
                return "";
            }
            if (((Object)((Object)CellType.ERROR)).equals((Object)cellType2)) {
                return FormulaError.forInt(cell.getErrorCellValue()).getString();
            }
            if (((Object)((Object)CellType.STRING)).equals((Object)cellType2)) {
                return cell.getStringCellValue();
            }
            if (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType2)) {
                return Double.toString(cell.getNumericCellValue());
            }
            return this.dataFormatter().formatCellValue(cell);
        }
        return this.dataFormatter().formatCellValue(cell);
    }

    public Workbook getWorkbook(Configuration conf, URI uri) {
        Workbook workbook;
        block7: {
            try (FSDataInputStream ins = FileSystem.get((URI)uri, (Configuration)conf).open(new Path(uri));){
                Option<Object> option = this.options.maxRowsInMemory();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int maxRows = BoxesRunTime.unboxToInt(some.value());
                    StreamingReader.Builder builder = StreamingReader.builder().bufferSize(maxRows);
                    Option<String> option2 = this.options.workbookPassword();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        String password = (String)some2.value();
                        builder.password(password);
                    }
                    workbook = builder.open((InputStream)ins);
                    break block7;
                }
                Option<String> option3 = this.options.workbookPassword();
                if (option3 instanceof Some) {
                    Some some = (Some)option3;
                    String password = (String)some.value();
                    workbook = WorkbookFactory.create((InputStream)ins, password);
                } else {
                    workbook = WorkbookFactory.create((InputStream)ins);
                }
            }
        }
        return workbook;
    }

    public SheetData<Vector<Cell>> getSheetData(Configuration conf, URI uri) {
        SheetData<Vector<Cell>> sheetData;
        Workbook workbook = this.getWorkbook(conf, uri);
        DataLocator excelReader = DataLocator$.MODULE$.apply(this.options);
        try {
            Iterator<Vector<Cell>> rowIter = excelReader.readFrom(workbook);
            sheetData = new SheetData<Vector<Cell>>(rowIter, (Seq<Closeable>)new $colon$colon<Nothing$>((Nothing$)((Object)workbook), Nil$.MODULE$));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = option.get();
                workbook.close();
                throw t;
            }
            throw throwable;
        }
        return sheetData;
    }

    public Tuple2<SheetData<Vector<Cell>>, Vector<String>> parseSheetData(Configuration conf, Seq<URI> uris) {
        Vector<String> vector;
        ObjectRef<SheetData<Vector<Cell>>> sheetData = ObjectRef.create(this.getSheetData(conf, (URI)uris.head()));
        if (((SheetData)sheetData.elem).rowIterator().isEmpty()) {
            vector = package$.MODULE$.Vector().empty();
        } else {
            try {
                Vector<String> vector2;
                if (this.options.header()) {
                    Vector<String> r = this.getColumnNames((Vector)((SheetData)sheetData.elem).rowIterator().next());
                    sheetData.elem = ((SheetData)sheetData.elem).modifyIterator((Function1<Iterator, Iterator> & Serializable & scala.Serializable)x$1 -> x$1.drop($this.options.ignoreAfterHeader()));
                    vector2 = r;
                } else {
                    Vector headerRow = (Vector)((SheetData)sheetData.elem).rowIterator().next();
                    Vector<String> r = this.getColumnNames(headerRow);
                    sheetData.elem = ((SheetData)sheetData.elem).modifyIterator((Function1<Iterator, Iterator> & Serializable & scala.Serializable)iter -> package$.MODULE$.Iterator().apply(Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{headerRow})).$plus$plus((Function0<Iterator> & Serializable & scala.Serializable)() -> iter));
                    vector2 = r;
                }
                Vector<String> colNames = vector2;
                int numberOfRowToIgnore = this.options.header() ? this.options.ignoreAfterHeader() + 1 : 0;
                sheetData.elem = ((TraversableOnce)uris.tail()).foldLeft((SheetData)sheetData.elem, (Function2<SheetData, URI, SheetData> & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                    Tuple2<SheetData, URI> tuple2 = new Tuple2<SheetData, URI>((SheetData)x0$1, (URI)x1$1);
                    if (tuple2 != null) {
                        SheetData rs = tuple2._1();
                        URI path = tuple2._2();
                        SheetData<Vector<Cell>> newRows = this.getSheetData(conf, path).modifyIterator((Function1<Iterator<Vector<Cell>>, Iterator<Vector<Cell>>>)(Function1<Iterator, Iterator> & Serializable & scala.Serializable)x$2 -> x$2.drop(numberOfRowToIgnore));
                        return rs.append(newRows);
                    }
                    throw new MatchError(tuple2);
                });
                this.options.excerptSize().foreach((JFunction1$mcVI$sp & scala.Serializable)excerptSize -> {
                    sheetData$1.elem = ((SheetData)sheetData$1.elem).modifyIterator((Function1<Iterator, Iterator> & Serializable & scala.Serializable)x$3 -> x$3.take(excerptSize));
                });
                vector = colNames;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable t = option.get();
                    ((SheetData)sheetData.elem).close();
                    throw t;
                }
                throw throwable;
            }
        }
        Vector<String> colNames = vector;
        return new Tuple2<SheetData, GenTraversable>((SheetData)sheetData.elem, colNames);
    }

    public Vector<String> getColumnNames(Vector<Cell> firstRow) {
        Vector vector;
        GenTraversable rowNumColumn;
        GenTraversable genTraversable = rowNumColumn = this.options.columnNameOfRowNumber().isDefined() ? (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.options.columnNameOfRowNumber().get()})) : package$.MODULE$.Vector().empty();
        if (this.options.header()) {
            Vector headerNames = firstRow.map((Function1<Cell, String> & Serializable & scala.Serializable)x$1 -> this.dataFormatter().formatCellValue((Cell)x$1), Vector$.MODULE$.canBuildFrom());
            Vector nonNullHeaderNames = (Vector)headerNames.filter((Function1<String, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(ExcelHelper.$anonfun$getColumnNames$2(x$4)));
            Set duplicates = ((MapLike)nonNullHeaderNames.groupBy((Function1<String, String> & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x)).filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean(ExcelHelper.$anonfun$getColumnNames$4(x$5)))).keySet();
            vector = ((TraversableLike)firstRow.zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                block4: {
                    String value;
                    int index;
                    block6: {
                        block5: {
                            CellType cellType;
                            tuple2 = x0$1;
                            if (tuple2 == null) break block4;
                            Cell cell = (Cell)tuple2._1();
                            index = tuple2._2$mcI$sp();
                            value = this.dataFormatter().formatCellValue(cell);
                            CellType cellType2 = cellType = cell.getCellType();
                            CellType cellType3 = CellType.ERROR;
                            if (!(cellType2 == null ? cellType3 != null : !((Object)((Object)cellType2)).equals((Object)cellType3))) break block5;
                            CellType cellType4 = cellType;
                            CellType cellType5 = CellType.BLANK;
                            if (!(cellType4 == null ? cellType5 != null : !((Object)((Object)cellType4)).equals((Object)cellType5))) break block5;
                            CellType cellType6 = cellType;
                            CellType cellType7 = CellType._NONE;
                            if ((cellType6 == null ? cellType7 != null : !((Object)((Object)cellType6)).equals((Object)cellType7)) && !value.isEmpty()) break block6;
                        }
                        return new StringBuilder(2).append("_c").append(index).toString();
                    }
                    if (duplicates.contains(value)) {
                        return new StringBuilder(0).append(value).append(index).toString();
                    }
                    return value;
                }
                throw new MatchError(tuple2);
            }, Vector$.MODULE$.canBuildFrom());
        } else {
            vector = ((TraversableLike)firstRow.zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    int index = tuple2._2$mcI$sp();
                    return new StringBuilder(2).append("_c").append(index).toString();
                }
                throw new MatchError(tuple2);
            }, Vector$.MODULE$.canBuildFrom());
        }
        Vector dataColumns = vector;
        return ((Vector)rowNumColumn).$plus$plus(dataColumns, Vector$.MODULE$.canBuildFrom());
    }

    public AreaReference parsedRangeAddress() {
        return (AreaReference)Try$.MODULE$.apply((Function0<AreaReference> & Serializable & scala.Serializable)() -> {
            CellReference cellRef = new CellReference($this.options.dataAddress());
            return new AreaReference(cellRef, new CellReference(cellRef.getSheetName(), SpreadsheetVersion.EXCEL2007.getLastRowIndex(), SpreadsheetVersion.EXCEL2007.getLastColumnIndex(), false, false), SpreadsheetVersion.EXCEL2007);
        }).getOrElse((Function0<AreaReference> & Serializable & scala.Serializable)() -> new AreaReference($this.options.dataAddress(), SpreadsheetVersion.EXCEL2007));
    }

    public static final /* synthetic */ boolean $anonfun$getColumnNames$2(String x$4) {
        return x$4 != null;
    }

    public static final /* synthetic */ boolean $anonfun$getColumnNames$4(Tuple2 x$5) {
        return ((SeqLike)x$5._2()).size() > 1;
    }

    public ExcelHelper(ExcelOptions options) {
        this.options = options;
    }
}

