/*
 * Decompiled with CFR 0.152.
 */
package dev.mauch.spark.excel.v2;

import dev.mauch.spark.excel.v2.ExcelDateTimeStringUtils$;
import dev.mauch.spark.excel.v2.ExcelFilters;
import dev.mauch.spark.excel.v2.ExcelHeaderChecker;
import dev.mauch.spark.excel.v2.ExcelHelper;
import dev.mauch.spark.excel.v2.ExcelHelper$;
import dev.mauch.spark.excel.v2.ExcelOptions;
import dev.mauch.spark.excel.v2.ExcelParser$;
import dev.mauch.spark.excel.v2.ExcelParserBase;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tMd\u0001\u0002\u0015*\u0001QB\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t'\u0002\u0011\t\u0011)A\u0005\u0017\"AA\u000b\u0001BC\u0002\u0013\u0005Q\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003W\u0011!Q\u0006A!A!\u0002\u0013Y\u0006\"B7\u0001\t\u0003q\u0007\"B7\u0001\t\u0003!\b\"B7\u0001\t\u0003A\bb\u0002?\u0001\u0005\u0004%I! \u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003\u007f\u000b\u0019\t)\u0001\u0001\u0003\u0002\b!I\u0011q\u0005\u0001C\u0002\u0013%\u0011\u0011\u0006\u0005\t\u0003w\u0001\u0001\u0015!\u0003\u0002,!I\u0011Q\b\u0001C\u0002\u0013%\u0011q\b\u0005\t\u0003/\u0002\u0001\u0015!\u0003\u0002B!I\u0011\u0011\f\u0001C\u0002\u0013%\u00111\f\u0005\t\u0003S\u0002\u0001\u0015!\u0003\u0002^!I\u00111\u000e\u0001C\u0002\u0013%\u0011Q\u000e\u0005\t\u0003\u000b\u0003\u0001\u0015!\u0003\u0002p!I\u0011q\u0011\u0001C\u0002\u0013%\u0011\u0011\u0012\u0005\t\u0003#\u0003\u0001\u0015!\u0003\u0002\f\"Q\u00111\u0013\u0001\t\u0006\u0004%I!!&\t\u0015\u0005\r\u0006\u0001#b\u0001\n\u0013\t)\u000bC\u0005\u0002.\u0002\u0011\r\u0011\"\u0003\u00020\"A\u0011q\u0017\u0001!\u0002\u0013\t\t\fC\u0004\u0002:\u0002!\t\"a/\t\u0013\u0005-\u0007A1A\u0005\n\u00055\u0007\u0002CAk\u0001\u0001\u0006I!a4\t\u0013\u0005]\u0007A1A\u0005\n\u0005e\u0007\u0002CA}\u0001\u0001\u0006I!a7\t\u000f\u0005m\b\u0001\"\u0003\u0002~\"9!q\u0003\u0001\u0005\n\te\u0001\"\u0003B\u0016\u0001\t\u0007I\u0011\u0001B\u0017\u0011!\u0011\t\u0005\u0001Q\u0001\n\t=\u0002b\u0002B\"\u0001\u0011%!QI\u0004\b\u0005\u0017J\u0003\u0012\u0001B'\r\u0019A\u0013\u0006#\u0001\u0003P!1Q.\nC\u0001\u0005#BqAa\u0015&\t\u0003\u0011)FA\u0006Fq\u000e,G\u000eU1sg\u0016\u0014(B\u0001\u0016,\u0003\t1(G\u0003\u0002-[\u0005)Q\r_2fY*\u0011afL\u0001\u0006gB\f'o\u001b\u0006\u0003aE\nQ!\\1vG\"T\u0011AM\u0001\u0004I\u001648\u0001A\n\u0005\u0001UZd\t\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtG\u0001\u0004B]f\u0014VM\u001a\t\u0003y\u0011k\u0011!\u0010\u0006\u0003}}\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003]\u0001S!!\u0011\"\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0015aA8sO&\u0011Q)\u0010\u0002\b\u0019><w-\u001b8h!\t9\u0005*D\u0001*\u0013\tI\u0015FA\bFq\u000e,G\u000eU1sg\u0016\u0014()Y:f\u0003)!\u0017\r^1TG\",W.\u0019\t\u0003\u0019Fk\u0011!\u0014\u0006\u0003\u001d>\u000bQ\u0001^=qKNT!\u0001U \u0002\u0007M\fH.\u0003\u0002S\u001b\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u001dI,\u0017/^5sK\u0012\u001c6\r[3nC\u00069q\u000e\u001d;j_:\u001cX#\u0001,\u0011\u0005\u001d;\u0016B\u0001-*\u00051)\u0005pY3m\u001fB$\u0018n\u001c8t\u0003!y\u0007\u000f^5p]N\u0004\u0013a\u00024jYR,'o\u001d\t\u00049\u0012<gBA/c\u001d\tq\u0016-D\u0001`\u0015\t\u00017'\u0001\u0004=e>|GOP\u0005\u0002q%\u00111mN\u0001\ba\u0006\u001c7.Y4f\u0013\t)gMA\u0002TKFT!aY\u001c\u0011\u0005!\\W\"A5\u000b\u0005)|\u0015aB:pkJ\u001cWm]\u0005\u0003Y&\u0014aAR5mi\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0003paF\u00148\u000f\u0005\u0002H\u0001!)!J\u0002a\u0001\u0017\")1K\u0002a\u0001\u0017\")AK\u0002a\u0001-\")!L\u0002a\u00017R!q.\u001e<x\u0011\u0015Qu\u00011\u0001L\u0011\u0015\u0019v\u00011\u0001L\u0011\u0015!v\u00011\u0001W)\ry\u0017p\u001f\u0005\u0006u\"\u0001\raS\u0001\u0007g\u000eDW-\\1\t\u000bQC\u0001\u0019\u0001,\u0002\u0017\u0015D8-\u001a7IK2\u0004XM]\u000b\u0002}B\u0011qi`\u0005\u0004\u0003\u0003I#aC#yG\u0016d\u0007*\u001a7qKJ\fA\"\u001a=dK2DU\r\u001c9fe\u0002\u0012aBV1mk\u0016\u001cuN\u001c<feR,'\u000fE\u00047\u0003\u0013\ti!!\t\n\u0007\u0005-qGA\u0005Gk:\u001cG/[8ocA!\u0011qBA\u000f\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011!C;tKJlw\u000eZ3m\u0015\u0011\t9\"!\u0007\u0002\u0005M\u001c(bAA\u000e\u0001\u0006\u0019\u0001o\\5\n\t\u0005}\u0011\u0011\u0003\u0002\u0005\u0007\u0016dG\u000eE\u00027\u0003GI1!!\n8\u0005\r\te._\u0001\ra\u0006\u00148/\u001a3TG\",W.Y\u000b\u0003\u0003W\u0001b!!\f\u00024\u0005URBAA\u0018\u0015\r\t\tdN\u0001\u000bG>dG.Z2uS>t\u0017bA3\u00020A\u0019A*a\u000e\n\u0007\u0005eRJA\u0006TiJ,8\r\u001e$jK2$\u0017!\u00049beN,GmU2iK6\f\u0007%A\u0007u_.,g.\u00138eKb\f%O]\u000b\u0003\u0003\u0003\u0002RANA\"\u0003\u000fJ1!!\u00128\u0005\u0015\t%O]1z!\u0011\tI%a\u0015\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\nA\u0001\\1oO*\u0011\u0011\u0011K\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002V\u0005-#aB%oi\u0016<WM]\u0001\u000fi>\\WM\\%oI\u0016D\u0018I\u001d:!\u0003E\u0011xn\u001e(v[\n,'\u000fU8tSRLwN\\\u000b\u0003\u0003;\u0002RANA0\u0003GJ1!!\u00198\u0005\u0019y\u0005\u000f^5p]B\u0019a'!\u001a\n\u0007\u0005\u001dtGA\u0002J]R\f!C]8x\u001dVl'-\u001a:Q_NLG/[8oA\u0005Y!/Z9vSJ,GMU8x+\t\ty\u0007E\u00037\u0003c\n)(C\u0002\u0002t]\u0012AaU8nKB!\u0011qOAA\u001b\t\tIH\u0003\u0003\u0002|\u0005u\u0014aC3yaJ,7o]5p]NT1!a P\u0003!\u0019\u0017\r^1msN$\u0018\u0002BAB\u0003s\u0012!cR3oKJL7-\u00138uKJt\u0017\r\u001c*po\u0006a!/Z9vSJ,GMU8xA\u00051an\u001c*poN,\"!a#\u000f\u0007Y\ni)C\u0002\u0002\u0010^\nAAT8oK\u00069an\u001c*poN\u0004\u0013A\u0005;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJ,\"!a&\u0011\t\u0005e\u0015qT\u0007\u0003\u00037SA!!(\u0002~\u0005!Q\u000f^5m\u0013\u0011\t\t+a'\u0003%QKW.Z:uC6\u0004hi\u001c:nCR$XM]\u0001\u000eI\u0006$XMR8s[\u0006$H/\u001a:\u0016\u0005\u0005\u001d\u0006\u0003BAM\u0003SKA!a+\u0002\u001c\niA)\u0019;f\r>\u0014X.\u0019;uKJ\fQ\u0002];tQ\u0016$g)\u001b7uKJ\u001cXCAAY!\r9\u00151W\u0005\u0004\u0003kK#\u0001D#yG\u0016dg)\u001b7uKJ\u001c\u0018A\u00049vg\",GMR5mi\u0016\u00148\u000fI\u0001\u0010O\u0016$8)\u001e:sK:$\u0018J\u001c9viV\u0011\u0011Q\u0018\t\u0005\u0003\u007f\u000b9-\u0004\u0002\u0002B*\u0019a*a1\u000b\u0007\u0005\u0015w(\u0001\u0004v]N\fg-Z\u0005\u0005\u0003\u0013\f\tM\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001e\fqB^1mk\u0016\u001cuN\u001c<feR,'o]\u000b\u0003\u0003\u001f\u0004RANA\"\u0003#\u00042!a5\f\u001b\u0005\u0001\u0011\u0001\u0005<bYV,7i\u001c8wKJ$XM]:!\u00035!WmY5nC2\u0004\u0016M]:feV\u0011\u00111\u001c\t\bm\u0005%\u0011Q\\Aw!\u0011\ty.a:\u000f\t\u0005\u0005\u00181\u001d\t\u0003=^J1!!:8\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011^Av\u0005\u0019\u0019FO]5oO*\u0019\u0011Q]\u001c\u0011\t\u0005=\u0018Q_\u0007\u0003\u0003cTA!a=\u0002P\u0005!Q.\u0019;i\u0013\u0011\t90!=\u0003\u0015\tKw\rR3dS6\fG.\u0001\beK\u000eLW.\u00197QCJ\u001cXM\u001d\u0011\u0002\u001b5\f7.Z\"p]Z,'\u000f^3s)!\t\t.a@\u0003\u0004\t5\u0001b\u0002B\u0001?\u0001\u0007\u0011Q\\\u0001\u0005]\u0006lW\rC\u0004\u0003\u0006}\u0001\rAa\u0002\u0002\u0011\u0011\fG/\u0019+za\u0016\u00042\u0001\u0014B\u0005\u0013\r\u0011Y!\u0014\u0002\t\t\u0006$\u0018\rV=qK\"9!qB\u0010A\u0002\tE\u0011\u0001\u00038vY2\f'\r\\3\u0011\u0007Y\u0012\u0019\"C\u0002\u0003\u0016]\u0012qAQ8pY\u0016\fg.A\u0007ok2d7+\u00194f\t\u0006$X/\u001c\u000b\u000b\u00057\u0011\tC!\n\u0003(\t%B\u0003BA\u0011\u0005;AqAa\b!\u0001\u0004\t\t.A\u0005d_:4XM\u001d;fe\"9!1\u0005\u0011A\u0002\u00055\u0011!\u00023biVl\u0007b\u0002B\u0001A\u0001\u0007\u0011Q\u001c\u0005\b\u0005\u001f\u0001\u0003\u0019\u0001B\t\u0011\u0015!\u0006\u00051\u0001W\u0003\u0015\u0001\u0018M]:f+\t\u0011y\u0003E\u00047\u0003\u0013\u0011\tDa\u000e\u0011\u000bq\u0013\u0019$!\u0004\n\u0007\tUbM\u0001\u0004WK\u000e$xN\u001d\t\u0006m\u0005}#\u0011\b\t\u0005\u0005w\u0011i$\u0004\u0002\u0002~%!!qHA?\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\rA\f'o]3!\u0003\u001d\u0019wN\u001c<feR$BAa\u000e\u0003H!9!\u0011J\u0012A\u0002\tE\u0012A\u0002;pW\u0016t7/A\u0006Fq\u000e,G\u000eU1sg\u0016\u0014\bCA$&'\t)S\u0007\u0006\u0002\u0003N\u0005i\u0001/\u0019:tK&#XM]1u_J$\"Ba\u0016\u0003^\t\r$q\rB9!\u0015a&\u0011\fB\u001d\u0013\r\u0011YF\u001a\u0002\t\u0013R,'/\u0019;pe\"9!qL\u0014A\u0002\t\u0005\u0014\u0001\u0002:poN\u0004R\u0001\u0018B-\u0005cAaA!\u001a(\u0001\u0004y\u0017A\u00029beN,'\u000fC\u0004\u0003j\u001d\u0002\rAa\u001b\u0002\u001b!,\u0017\rZ3s\u0007\",7m[3s!\r9%QN\u0005\u0004\u0005_J#AE#yG\u0016d\u0007*Z1eKJ\u001c\u0005.Z2lKJDQA_\u0014A\u0002-\u0003")
public class ExcelParser
implements Logging,
ExcelParserBase {
    private TimestampFormatter timestampFormatter;
    private DateFormatter dateFormatter;
    private final StructType dataSchema;
    private final StructType requiredSchema;
    private final ExcelOptions options;
    private final ExcelHelper excelHelper;
    private final Seq<StructField> parsedSchema;
    private final Integer[] tokenIndexArr;
    private final Option<Object> rowNumberPosition;
    private final Some<GenericInternalRow> requiredRow;
    private final None$ noRows;
    private final ExcelFilters pushedFilters;
    private final Function1<Cell, Object>[] valueConverters;
    private final Function1<String, BigDecimal> decimalParser;
    private final Function1<Vector<Cell>, Option<InternalRow>> parse;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Iterator<InternalRow> parseIterator(Iterator<Vector<Cell>> iterator, ExcelParser excelParser, ExcelHeaderChecker excelHeaderChecker, StructType structType) {
        return ExcelParser$.MODULE$.parseIterator(iterator, excelParser, excelHeaderChecker, structType);
    }

    @Override
    public BadRecordException badRecord(InternalRow[] partialResults, Throwable baseException) {
        return ExcelParserBase.badRecord$(this, partialResults, baseException);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ExcelOptions options() {
        return this.options;
    }

    private ExcelHelper excelHelper() {
        return this.excelHelper;
    }

    private Seq<StructField> parsedSchema() {
        return this.parsedSchema;
    }

    private Integer[] tokenIndexArr() {
        return this.tokenIndexArr;
    }

    private Option<Object> rowNumberPosition() {
        return this.rowNumberPosition;
    }

    private Some<GenericInternalRow> requiredRow() {
        return this.requiredRow;
    }

    private None$ noRows() {
        return this.noRows;
    }

    private TimestampFormatter timestampFormatter$lzycompute() {
        ExcelParser excelParser = this;
        synchronized (excelParser) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.timestampFormatter = ExcelDateTimeStringUtils$.MODULE$.getTimestampFormatter(this.options());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampFormatter() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.timestampFormatter$lzycompute();
        }
        return this.timestampFormatter;
    }

    private DateFormatter dateFormatter$lzycompute() {
        ExcelParser excelParser = this;
        synchronized (excelParser) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dateFormatter = ExcelDateTimeStringUtils$.MODULE$.getDateFormatter(this.options());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dateFormatter;
    }

    private DateFormatter dateFormatter() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.dateFormatter$lzycompute();
        }
        return this.dateFormatter;
    }

    private ExcelFilters pushedFilters() {
        return this.pushedFilters;
    }

    @Override
    public UTF8String getCurrentInput() {
        return UTF8String.fromString((String)"TODO: how to show the corrupted record?");
    }

    private Function1<Cell, Object>[] valueConverters() {
        return this.valueConverters;
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    private Function1<Cell, Object> makeConverter(String name, DataType dataType, boolean nullable) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof ByteType) {
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> {
                CellType cellType;
                return this.nullSafeDatum((Cell)d, name, nullable, this.options(), ((Object)((Object)CellType.NUMERIC)).equals((Object)(cellType = d.getCellType())) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToByte(ExcelParser.$anonfun$makeConverter$2(x$2)) : (((Object)((Object)CellType.FORMULA)).equals((Object)cellType) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$3 -> {
                    CellType cellType = x$3.getCachedFormulaResultType();
                    if (((Object)((Object)CellType.BLANK)).equals((Object)cellType) ? true : (((Object)((Object)CellType._NONE)).equals((Object)cellType) ? true : ((Object)((Object)CellType.ERROR)).equals((Object)cellType))) {
                        return null;
                    }
                    if (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType)) {
                        return BoxesRunTime.boxToByte((byte)d.getNumericCellValue());
                    }
                    return BoxesRunTime.boxToByte(new StringOps(Predef$.MODULE$.augmentString(d.getStringCellValue())).toByte());
                } : (Function1<Cell, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToByte(ExcelParser.$anonfun$makeConverter$4(x$4))));
            };
        }
        if (dataType2 instanceof ShortType) {
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> {
                CellType cellType;
                return this.nullSafeDatum((Cell)d, name, nullable, this.options(), ((Object)((Object)CellType.NUMERIC)).equals((Object)(cellType = d.getCellType())) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToShort(ExcelParser.$anonfun$makeConverter$6(x$5)) : (((Object)((Object)CellType.FORMULA)).equals((Object)cellType) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$6 -> {
                    CellType cellType = x$6.getCachedFormulaResultType();
                    if (((Object)((Object)CellType.BLANK)).equals((Object)cellType) ? true : (((Object)((Object)CellType._NONE)).equals((Object)cellType) ? true : ((Object)((Object)CellType.ERROR)).equals((Object)cellType))) {
                        return null;
                    }
                    if (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType)) {
                        return BoxesRunTime.boxToShort((short)d.getNumericCellValue());
                    }
                    return BoxesRunTime.boxToShort(new StringOps(Predef$.MODULE$.augmentString(d.getStringCellValue())).toShort());
                } : (Function1<Cell, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToShort(ExcelParser.$anonfun$makeConverter$8(x$7))));
            };
        }
        if (dataType2 instanceof IntegerType) {
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> {
                CellType cellType;
                return this.nullSafeDatum((Cell)d, name, nullable, this.options(), ((Object)((Object)CellType.NUMERIC)).equals((Object)(cellType = d.getCellType())) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger(ExcelParser.$anonfun$makeConverter$10(x$8)) : (((Object)((Object)CellType.FORMULA)).equals((Object)cellType) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$9 -> {
                    CellType cellType = x$9.getCachedFormulaResultType();
                    if (((Object)((Object)CellType.BLANK)).equals((Object)cellType) ? true : (((Object)((Object)CellType._NONE)).equals((Object)cellType) ? true : ((Object)((Object)CellType.ERROR)).equals((Object)cellType))) {
                        return null;
                    }
                    if (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType)) {
                        return BoxesRunTime.boxToInteger((int)d.getNumericCellValue());
                    }
                    return BoxesRunTime.boxToInteger(new StringOps(Predef$.MODULE$.augmentString(d.getStringCellValue())).toInt());
                } : (Function1<Cell, Object> & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger(ExcelParser.$anonfun$makeConverter$12(x$10))));
            };
        }
        if (dataType2 instanceof LongType) {
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> {
                CellType cellType;
                return this.nullSafeDatum((Cell)d, name, nullable, this.options(), ((Object)((Object)CellType.NUMERIC)).equals((Object)(cellType = d.getCellType())) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong(ExcelParser.$anonfun$makeConverter$14(x$11)) : (((Object)((Object)CellType.FORMULA)).equals((Object)cellType) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$12 -> {
                    CellType cellType = x$12.getCachedFormulaResultType();
                    if (((Object)((Object)CellType.BLANK)).equals((Object)cellType) ? true : (((Object)((Object)CellType._NONE)).equals((Object)cellType) ? true : ((Object)((Object)CellType.ERROR)).equals((Object)cellType))) {
                        return null;
                    }
                    if (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType)) {
                        return BoxesRunTime.boxToLong((long)d.getNumericCellValue());
                    }
                    return BoxesRunTime.boxToLong(new StringOps(Predef$.MODULE$.augmentString(d.getStringCellValue())).toLong());
                } : (Function1<Cell, Object> & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong(ExcelParser.$anonfun$makeConverter$16(x$13))));
            };
        }
        if (dataType2 instanceof FloatType) {
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> {
                CellType cellType;
                return this.nullSafeDatum((Cell)d, name, nullable, this.options(), ((Object)((Object)CellType.NUMERIC)).equals((Object)(cellType = d.getCellType())) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToFloat(ExcelParser.$anonfun$makeConverter$18(x$14)) : (((Object)((Object)CellType.FORMULA)).equals((Object)cellType) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$15 -> {
                    CellType cellType = x$15.getCachedFormulaResultType();
                    if (((Object)((Object)CellType.BLANK)).equals((Object)cellType) ? true : (((Object)((Object)CellType._NONE)).equals((Object)cellType) ? true : ((Object)((Object)CellType.ERROR)).equals((Object)cellType))) {
                        return null;
                    }
                    if (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType)) {
                        return BoxesRunTime.boxToFloat((float)d.getNumericCellValue());
                    }
                    return BoxesRunTime.boxToFloat(new StringOps(Predef$.MODULE$.augmentString(d.getStringCellValue())).toFloat());
                } : (Function1<Cell, Object> & Serializable & scala.Serializable)x$16 -> {
                    String string = x$16.getStringCellValue();
                    String string2 = this.options().nanValue();
                    String string3 = string;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        return BoxesRunTime.boxToFloat(Float.NaN);
                    }
                    String string4 = this.options().negativeInf();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        return BoxesRunTime.boxToFloat(Float.NEGATIVE_INFINITY);
                    }
                    String string6 = this.options().positiveInf();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        return BoxesRunTime.boxToFloat(Float.POSITIVE_INFINITY);
                    }
                    return BoxesRunTime.boxToFloat(new StringOps(Predef$.MODULE$.augmentString(string)).toFloat());
                }));
            };
        }
        if (dataType2 instanceof DoubleType) {
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> {
                CellType cellType;
                return this.nullSafeDatum((Cell)d, name, nullable, this.options(), ((Object)((Object)CellType.NUMERIC)).equals((Object)(cellType = d.getCellType())) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToDouble(x$17.getNumericCellValue()) : (((Object)((Object)CellType.FORMULA)).equals((Object)cellType) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$18 -> {
                    CellType cellType = x$18.getCachedFormulaResultType();
                    if (((Object)((Object)CellType.BLANK)).equals((Object)cellType) ? true : ((Object)((Object)CellType._NONE)).equals((Object)cellType)) {
                        return null;
                    }
                    if (((Object)((Object)CellType.ERROR)).equals((Object)cellType)) {
                        return BoxesRunTime.boxToDouble(Double.NaN);
                    }
                    if (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType)) {
                        return BoxesRunTime.boxToDouble(d.getNumericCellValue());
                    }
                    String string = this.excelHelper().safeCellStringValue((Cell)d);
                    String string2 = this.options().nanValue();
                    String string3 = string;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        return BoxesRunTime.boxToDouble(Double.NaN);
                    }
                    String string4 = this.options().negativeInf();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        return BoxesRunTime.boxToDouble(Double.NEGATIVE_INFINITY);
                    }
                    String string6 = this.options().positiveInf();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        return BoxesRunTime.boxToDouble(Double.POSITIVE_INFINITY);
                    }
                    return BoxesRunTime.boxToDouble(new StringOps(Predef$.MODULE$.augmentString(string)).toDouble());
                } : (Function1<Cell, Object> & Serializable & scala.Serializable)x$19 -> {
                    String string = this.excelHelper().safeCellStringValue((Cell)x$19);
                    String string2 = this.options().nanValue();
                    String string3 = string;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        return BoxesRunTime.boxToDouble(Double.NaN);
                    }
                    String string4 = this.options().negativeInf();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        return BoxesRunTime.boxToDouble(Double.NEGATIVE_INFINITY);
                    }
                    String string6 = this.options().positiveInf();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        return BoxesRunTime.boxToDouble(Double.POSITIVE_INFINITY);
                    }
                    return BoxesRunTime.boxToDouble(new StringOps(Predef$.MODULE$.augmentString(string)).toDouble());
                }));
            };
        }
        if (dataType2 instanceof BooleanType) {
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> {
                CellType cellType;
                return this.nullSafeDatum((Cell)d, name, nullable, this.options(), ((Object)((Object)CellType.BOOLEAN)).equals((Object)(cellType = d.getCellType())) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean(x$20.getBooleanCellValue()) : (((Object)((Object)CellType.FORMULA)).equals((Object)cellType) ? (Function1<Cell, Object> & Serializable & scala.Serializable)x$21 -> {
                    CellType cellType = x$21.getCachedFormulaResultType();
                    if (((Object)((Object)CellType.BLANK)).equals((Object)cellType) ? true : (((Object)((Object)CellType._NONE)).equals((Object)cellType) ? true : ((Object)((Object)CellType.ERROR)).equals((Object)cellType))) {
                        return null;
                    }
                    if (((Object)((Object)CellType.BOOLEAN)).equals((Object)cellType)) {
                        return BoxesRunTime.boxToBoolean(d.getBooleanCellValue());
                    }
                    return BoxesRunTime.boxToBoolean(new StringOps(Predef$.MODULE$.augmentString(d.getStringCellValue())).toBoolean());
                } : (Function1<Cell, Object> & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean(ExcelParser.$anonfun$makeConverter$28(x$22))));
            };
        }
        if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> this.nullSafeDatum((Cell)d, name, nullable, this.options(), (Function1<Cell, Object> & Serializable & scala.Serializable)datum -> {
                CellType cellType = datum.getCellType();
                if (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType) ? true : ((Object)((Object)CellType.FORMULA)).equals((Object)cellType)) {
                    return Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(datum.getNumericCellValue()), decimalType.precision(), decimalType.scale());
                }
                return Decimal$.MODULE$.apply(this.decimalParser().apply(datum.getStringCellValue()), decimalType.precision(), decimalType.scale());
            });
        }
        if (dataType2 instanceof TimestampType) {
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> this.nullSafeDatum((Cell)d, name, nullable, this.options(), (Function1<Cell, Object> & Serializable & scala.Serializable)datum -> {
                Long l;
                if (DateUtil.isCellDateFormatted(datum)) {
                    return BoxesRunTime.boxToLong(datum.getDateCellValue().getTime() * 1000L);
                }
                CellType cellType = datum.getCellType();
                if (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType) ? true : ((Object)((Object)CellType.FORMULA)).equals((Object)cellType)) {
                    return BoxesRunTime.boxToLong((long)datum.getNumericCellValue());
                }
                String v = this.excelHelper().safeCellStringValue((Cell)datum);
                try {
                    l = BoxesRunTime.boxToLong(this.timestampFormatter().parse(v));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = option.get();
                        l = ExcelDateTimeStringUtils$.MODULE$.stringToTimestamp(v, this.options().zoneId()).getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> {
                            throw e;
                        });
                    }
                    throw throwable;
                }
                return l;
            });
        }
        if (dataType2 instanceof DateType) {
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> this.nullSafeDatum((Cell)d, name, nullable, this.options(), (Function1<Cell, Object> & Serializable & scala.Serializable)datum -> {
                Integer n;
                if (DateUtil.isCellDateFormatted(datum)) {
                    return BoxesRunTime.boxToInteger(DateTimeUtils$.MODULE$.fromJavaDate(new Date(datum.getDateCellValue().getTime())));
                }
                CellType cellType = datum.getCellType();
                if (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType) ? true : ((Object)((Object)CellType.FORMULA)).equals((Object)cellType)) {
                    return BoxesRunTime.boxToInteger((int)datum.getNumericCellValue());
                }
                String v = this.excelHelper().safeCellStringValue((Cell)datum);
                try {
                    n = BoxesRunTime.boxToInteger(this.dateFormatter().parse(v));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = option.get();
                        n = ExcelDateTimeStringUtils$.MODULE$.stringToDate(v, this.options().zoneId()).getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> {
                            throw e;
                        });
                    }
                    throw throwable;
                }
                return n;
            });
        }
        if (dataType2 instanceof StringType) {
            return (Function1<Cell, Object> & Serializable & scala.Serializable)d -> this.nullSafeDatum((Cell)d, name, nullable, this.options(), (Function1<Cell, Object>)(Function1<Cell, UTF8String> & Serializable & scala.Serializable)datum -> UTF8String.fromString((String)this.excelHelper().safeCellStringValue((Cell)datum)));
        }
        throw new RuntimeException(new StringBuilder(18).append("Unsupported type: ").append(dataType.typeName()).toString());
    }

    private Object nullSafeDatum(Cell datum, String name, boolean nullable, ExcelOptions options, Function1<Cell, Object> converter) {
        Object ret;
        Object object;
        CellType cellType = datum.getCellType();
        CellType cellType2 = CellType.FORMULA;
        CellType cellType3 = !(cellType != null ? !((Object)((Object)cellType)).equals((Object)cellType2) : cellType2 != null) ? datum.getCachedFormulaResultType() : datum.getCellType();
        CellType cellType4 = cellType3;
        if (((Object)((Object)CellType.BLANK)).equals((Object)cellType4) ? true : ((Object)((Object)CellType._NONE)).equals((Object)cellType4)) {
            object = null;
        } else if (((Object)((Object)CellType.ERROR)).equals((Object)cellType4)) {
            object = options.useNullForErrorCells() ? null : converter.apply(datum);
        } else if (((Object)((Object)CellType.STRING)).equals((Object)cellType4)) {
            String string = datum.getStringCellValue();
            String string2 = options.nullValue();
            object = !(string != null ? !string.equals(string2) : string2 != null) ? null : converter.apply(datum);
        } else {
            object = ret = converter.apply(datum);
        }
        if (ret == null && !nullable) {
            throw new RuntimeException(new StringBuilder(44).append("null value found but field ").append(name).append(" is not nullable.").toString());
        }
        return ret;
    }

    public Function1<Vector<Cell>, Option<InternalRow>> parse() {
        return this.parse;
    }

    private Option<InternalRow> convert(Vector<Cell> tokens) {
        if (tokens == null) {
            throw this.badRecord((InternalRow[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InternalRow.class)), new RuntimeException("Malformed Excel record"));
        }
        Option badRecordException = tokens.length() != this.parsedSchema().length() ? new Some<RuntimeException>(new RuntimeException("Malformed Excel record")) : None$.MODULE$;
        GenericInternalRow row = this.requiredRow().get();
        boolean skipRow = false;
        for (int i = 0; i < this.requiredSchema.length(); ++i) {
            try {
                if (skipRow) {
                    row.setNullAt(i);
                    continue;
                }
                if (this.rowNumberPosition().isDefined() && i == BoxesRunTime.unboxToInt(this.rowNumberPosition().get())) {
                    if (tokens.isEmpty()) {
                        row.setNullAt(i);
                    } else {
                        row.update(i, (Object)BoxesRunTime.boxToInteger(tokens.head().getRowIndex()));
                    }
                } else {
                    row.update(i, this.valueConverters()[i].apply(tokens.apply(Predef$.MODULE$.Integer2int(this.tokenIndexArr()[i]))));
                }
                if (!this.pushedFilters().skipRow((InternalRow)row, i)) continue;
                skipRow = true;
                continue;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = option.get();
                    badRecordException = badRecordException.orElse((Function0<Some> & Serializable & scala.Serializable)() -> new Some<Throwable>(e));
                    row.setNullAt(i);
                    continue;
                }
                throw throwable;
            }
        }
        if (skipRow) {
            return this.noRows();
        }
        if (badRecordException.isDefined()) {
            throw this.badRecord((InternalRow[])Option$.MODULE$.option2Iterable(this.requiredRow()).toArray(ClassTag$.MODULE$.apply(InternalRow.class)), (Throwable)badRecordException.get());
        }
        return this.requiredRow();
    }

    public static final /* synthetic */ boolean $anonfun$parsedSchema$1(ExcelParser $this, StructField x$1) {
        String string = x$1.name();
        String string2 = $this.options().columnNameOfRowNumber().get();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ byte $anonfun$makeConverter$2(Cell x$2) {
        return (byte)x$2.getNumericCellValue();
    }

    public static final /* synthetic */ byte $anonfun$makeConverter$4(Cell x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4.getStringCellValue())).toByte();
    }

    public static final /* synthetic */ short $anonfun$makeConverter$6(Cell x$5) {
        return (short)x$5.getNumericCellValue();
    }

    public static final /* synthetic */ short $anonfun$makeConverter$8(Cell x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7.getStringCellValue())).toShort();
    }

    public static final /* synthetic */ int $anonfun$makeConverter$10(Cell x$8) {
        return (int)x$8.getNumericCellValue();
    }

    public static final /* synthetic */ int $anonfun$makeConverter$12(Cell x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10.getStringCellValue())).toInt();
    }

    public static final /* synthetic */ long $anonfun$makeConverter$14(Cell x$11) {
        return (long)x$11.getNumericCellValue();
    }

    public static final /* synthetic */ long $anonfun$makeConverter$16(Cell x$13) {
        return new StringOps(Predef$.MODULE$.augmentString(x$13.getStringCellValue())).toLong();
    }

    public static final /* synthetic */ float $anonfun$makeConverter$18(Cell x$14) {
        return (float)x$14.getNumericCellValue();
    }

    public static final /* synthetic */ boolean $anonfun$makeConverter$28(Cell x$22) {
        return new StringOps(Predef$.MODULE$.augmentString(x$22.getStringCellValue())).toBoolean();
    }

    public ExcelParser(StructType dataSchema, StructType requiredSchema, ExcelOptions options, Seq<Filter> filters) {
        this.dataSchema = dataSchema;
        this.requiredSchema = requiredSchema;
        this.options = options;
        Logging.$init$((Logging)this);
        ExcelParserBase.$init$(this);
        Predef$.MODULE$.require(requiredSchema.toSet().subsetOf(dataSchema.toSet()), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(56).append("requiredSchema (").append($this.requiredSchema.catalogString()).append(") should be the subset of ").append("dataSchema (").append($this.dataSchema.catalogString()).append(").").toString());
        this.excelHelper = ExcelHelper$.MODULE$.apply(options);
        this.parsedSchema = options.columnNameOfRowNumber().isDefined() ? (Seq)dataSchema.filter((Function1<StructField, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(ExcelParser.$anonfun$parsedSchema$1(this, x$1))) : dataSchema;
        this.tokenIndexArr = (Integer[])((TraversableOnce)requiredSchema.map((Function1<StructField, Integer> & Serializable & scala.Serializable)f -> this.parsedSchema().indexOf(f), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Integer.class));
        this.rowNumberPosition = options.columnNameOfRowNumber().isDefined() ? new Some<Integer>(BoxesRunTime.boxToInteger(requiredSchema.fieldIndex(options.columnNameOfRowNumber().get()))) : None$.MODULE$;
        this.requiredRow = new Some<GenericInternalRow>(new GenericInternalRow(requiredSchema.length()));
        this.noRows = None$.MODULE$;
        this.pushedFilters = new ExcelFilters(filters, requiredSchema);
        this.valueConverters = (Function1[])((TraversableOnce)requiredSchema.map((Function1<StructField, Function1> & Serializable & scala.Serializable)f -> this.makeConverter(f.name(), f.dataType(), f.nullable()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function1.class));
        this.decimalParser = (Function1<String, BigDecimal> & Serializable & scala.Serializable)s -> new BigDecimal((String)s);
        this.parse = requiredSchema.isEmpty() ? (Function1<Vector, Option> & Serializable & scala.Serializable)x$23 -> new Some<InternalRow>(InternalRow$.MODULE$.empty()) : (Function1<Vector, Option> & Serializable & scala.Serializable)input -> this.convert((Vector<Cell>)input);
    }

    public ExcelParser(StructType dataSchema, StructType requiredSchema, ExcelOptions options) {
        this(dataSchema, requiredSchema, options, Nil$.MODULE$);
    }

    public ExcelParser(StructType schema, ExcelOptions options) {
        this(schema, schema, options);
    }
}

