/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.mayusjsonutils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.mayuna.mayusjsonutils.objects.MayuJson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.NonNull;

public class JsonUtil {
    public static MayuJson createOrLoadJsonFromFile(@NonNull String path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return JsonUtil.createOrLoadJsonFromFile(new File(path));
    }

    public static MayuJson createOrLoadJsonFromFile(@NonNull Path path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return JsonUtil.createOrLoadJsonFromFile(path.toFile());
    }

    public static MayuJson createOrLoadJsonFromFile(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (!Files.exists(file.toPath(), new LinkOption[0]) && file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);
            outputStreamWriter.write("{}");
            outputStreamWriter.close();
        }
        return JsonUtil.loadJson(file.getPath());
    }

    public static MayuJson loadJson(@NonNull String file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        Path pathObject = Paths.get(file, new String[0]);
        if (!Files.exists(pathObject, new LinkOption[0])) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String line : Files.readAllLines(pathObject, StandardCharsets.UTF_8)) {
            stringBuilder.append(line);
        }
        if (stringBuilder.toString().equalsIgnoreCase("")) {
            stringBuilder.append("{}");
        }
        JsonObject jsonObject = new JsonParser().parse(stringBuilder.toString()).getAsJsonObject();
        return new MayuJson(pathObject.toFile(), jsonObject);
    }

    public static MayuJson saveJson(@NonNull String json, @NonNull File file) throws IOException {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        JsonObject jsonObject = new JsonParser().parse(json).getAsJsonObject();
        return JsonUtil.saveJson(jsonObject, file, true);
    }

    public static MayuJson saveJson(@NonNull JsonObject jsonObject, File file) throws IOException {
        if (jsonObject == null) {
            throw new NullPointerException("jsonObject is marked non-null but is null");
        }
        return JsonUtil.saveJson(jsonObject, file, true);
    }

    public static MayuJson saveJson(@NonNull JsonObject jsonObject, @NonNull File file, boolean pretty) throws IOException {
        if (jsonObject == null) {
            throw new NullPointerException("jsonObject is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        MayuJson mayuJson = new MayuJson(file, jsonObject);
        mayuJson.saveJson(pretty);
        return mayuJson;
    }
}

