/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.mayusjsonutils.objects;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.mayuna.mayusjsonutils.JsonUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;

public class MayuJson {
    private File file;
    private JsonObject jsonObject;

    public MayuJson(@NonNull JsonObject jsonObject) {
        if (jsonObject == null) {
            throw new NullPointerException("jsonObject is marked non-null but is null");
        }
        this.file = null;
        this.jsonObject = jsonObject;
    }

    public MayuJson(@NonNull File file, @NonNull JsonObject jsonObject) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (jsonObject == null) {
            throw new NullPointerException("jsonObject is marked non-null but is null");
        }
        this.file = file;
        this.jsonObject = jsonObject;
    }

    public void reloadJson() throws IOException {
        this.jsonObject = JsonUtil.createOrLoadJsonFromFile(this.file).getJsonObject();
    }

    public void saveJson() throws IOException {
        this.saveJson(true);
    }

    public void saveJson(boolean pretty) throws IOException {
        GsonBuilder gsonBuilder = new GsonBuilder().serializeNulls();
        if (pretty) {
            gsonBuilder.setPrettyPrinting();
        }
        Gson gson = gsonBuilder.create();
        FileOutputStream fileOutputStream = new FileOutputStream(this.file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);
        outputStreamWriter.write(gson.toJson((JsonElement)this.jsonObject));
        outputStreamWriter.close();
    }

    public JsonElement getOrNull(String memberName) {
        JsonElement jsonElement;
        if (this.jsonObject.has(memberName) && !(jsonElement = this.jsonObject.get(memberName)).isJsonNull()) {
            return jsonElement;
        }
        return null;
    }

    public JsonElement getOrCreate(String memberName, JsonElement defaultValue) {
        JsonElement jsonElement;
        if (this.jsonObject.has(memberName) && !(jsonElement = this.jsonObject.get(memberName)).isJsonNull()) {
            return jsonElement;
        }
        this.jsonObject.add(memberName, defaultValue);
        return defaultValue;
    }

    public MayuJson add(String memberName, JsonElement value) {
        this.jsonObject.add(memberName, value);
        return this;
    }

    public MayuJson add(String memberName, Number value) {
        this.jsonObject.addProperty(memberName, value);
        return this;
    }

    public MayuJson add(String memberName, String value) {
        this.jsonObject.addProperty(memberName, value);
        return this;
    }

    public MayuJson add(String memberName, Boolean value) {
        this.jsonObject.addProperty(memberName, value);
        return this;
    }

    public MayuJson add(String memberName, Character value) {
        this.jsonObject.addProperty(memberName, value);
        return this;
    }

    public MayuJson remove(String memberName) {
        this.jsonObject.remove(memberName);
        return this;
    }

    public boolean has(String memberName) {
        return this.jsonObject.has(memberName);
    }

    public void setJsonObject(String json) {
        this.jsonObject = new JsonParser().parse(json).getAsJsonObject();
    }

    public void setJsonObject(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public JsonObject getJsonObject() {
        return this.jsonObject;
    }
}

