/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.mayuslibrary.arguments;

import dev.mayuna.mayuslibrary.arguments.Argument;
import dev.mayuna.mayuslibrary.arguments.ArgumentSeparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

public class ArgumentParser {
    private final String arguments;
    private ArgumentSeparator argumentSeparator;
    private List<Argument> argumentList = new ArrayList<Argument>();

    public ArgumentParser(@NonNull String arguments) {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        this.arguments = arguments;
        this.argumentSeparator = ArgumentSeparator.SPACE;
        if (!arguments.equals("")) {
            this.parseArguments();
        }
    }

    public ArgumentParser(@NonNull String arguments, @NonNull ArgumentSeparator argumentSeparator) {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        if (argumentSeparator == null) {
            throw new NullPointerException("argumentSeparator is marked non-null but is null");
        }
        this.arguments = arguments;
        this.argumentSeparator = argumentSeparator;
        if (!arguments.equals("")) {
            this.parseArguments();
        }
    }

    public ArgumentParser parseArguments() {
        this.argumentList = new ArrayList<Argument>();
        if (this.argumentSeparator == ArgumentSeparator.LINE) {
            this.parseByLine();
        } else {
            this.parseBySpace();
        }
        return this;
    }

    public boolean hasAnyArguments() {
        return !this.argumentList.isEmpty();
    }

    public boolean hasArgumentAtIndex(int index) {
        return this.getArgumentAtIndex(index) != null;
    }

    public Argument getArgumentAtIndex(int index) {
        try {
            return this.argumentList.get(index);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public Argument getAllArgumentsAfterIndex(int index) {
        StringBuilder stringBuilder = new StringBuilder();
        if (index < 0) {
            return new Argument(this.arguments);
        }
        for (int x = index; x < this.argumentList.size(); ++x) {
            stringBuilder.append(this.argumentList.get(x).getValue()).append(" ");
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return new Argument(stringBuilder.deleteCharAt(stringBuilder.length() - 1).toString());
    }

    public Argument getAllArgumentsBetweenIndexes(int startIndex, int endIndex) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int x = startIndex; x < endIndex + 1 && x < this.argumentList.size(); ++x) {
            stringBuilder.append(this.argumentList.get(x).getValue()).append(" ");
        }
        return new Argument(stringBuilder.deleteCharAt(stringBuilder.length() - 1).toString());
    }

    public ArgumentParser setArgumentSeparator(ArgumentSeparator argumentSeparator) {
        this.argumentSeparator = argumentSeparator;
        return this.parseArguments();
    }

    private void parseBySpace() {
        Arrays.asList(this.arguments.split(" ")).forEach(parsedArgument -> this.argumentList.add(new Argument((String)parsedArgument)));
    }

    private void parseByLine() {
        Arrays.asList(this.arguments.split("\\|")).forEach(parsedArgument -> this.argumentList.add(new Argument(this.removeSpaces((String)parsedArgument))));
    }

    private String removeSpaces(String string) {
        int x;
        StringBuilder stringBuilder = new StringBuilder(string);
        for (x = 0; x < stringBuilder.length() - 1 && stringBuilder.charAt(0) == ' '; ++x) {
            stringBuilder.deleteCharAt(0);
        }
        for (x = stringBuilder.length() - 1; x > 0 && stringBuilder.charAt(x) == ' '; --x) {
            stringBuilder.deleteCharAt(x);
        }
        return stringBuilder.toString();
    }

    public String getArguments() {
        return this.arguments;
    }

    public ArgumentSeparator getArgumentSeparator() {
        return this.argumentSeparator;
    }

    public List<Argument> getArgumentList() {
        return this.argumentList;
    }
}

