/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.mayuslibrary.concurrent.event;

import java.util.UUID;
import java.util.function.Consumer;

public abstract class AbstractListener<T> {
    private final String name;
    private final Consumer<T> consumer;

    public AbstractListener(String name, Consumer<T> consumer) {
        this.name = name;
        this.consumer = consumer;
    }

    public AbstractListener(Consumer<T> consumer) {
        this.name = UUID.randomUUID().toString();
        this.consumer = consumer;
    }

    public void process(T object) {
        this.consumer.accept(object);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractListener)) {
            return false;
        }
        if (this.name == null) {
            return false;
        }
        AbstractListener that = (AbstractListener)o;
        return this.name.equals(that.name);
    }

    public String getName() {
        return this.name;
    }

    public Consumer<T> getConsumer() {
        return this.consumer;
    }
}

