/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.mayuslibrary.concurrent.event;

import dev.mayuna.mayuslibrary.concurrent.event.AbstractListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public abstract class EventBus<T> {
    protected List<AbstractListener<T>> listeners = Collections.synchronizedList(new ArrayList());

    public void callAllListeners(T object) {
        this.listeners.forEach(listener -> listener.process(object));
    }

    public boolean addListener(AbstractListener<T> listener) {
        return this.listeners.add(listener);
    }

    public boolean addListener(String name, Consumer<T> consumer) {
        return this.listeners.add(new AbstractListener<T>(name, consumer){});
    }

    public boolean removeListener(AbstractListener<T> listener) {
        return this.listeners.remove(listener);
    }

    public boolean removeListener(String name) {
        return this.listeners.remove(new AbstractListener<T>(name, null){});
    }

    public List<AbstractListener<T>> getListeners() {
        return this.listeners;
    }
}

