/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.mayuslibrary.exceptionreporting;

import dev.mayuna.mayuslibrary.concurrent.event.AbstractListener;
import dev.mayuna.mayuslibrary.exceptionreporting.ExceptionReport;
import java.util.function.Consumer;

public class ExceptionListener
extends AbstractListener<ExceptionReport> {
    private final String packageName;

    public ExceptionListener(String name, String packageName, Consumer<ExceptionReport> consumer) {
        super(name, consumer);
        this.packageName = packageName;
    }

    @Override
    public void process(ExceptionReport exceptionReport) {
        try {
            this.processException(exceptionReport);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void processException(ExceptionReport exceptionReport) {
        for (StackTraceElement element : exceptionReport.getThrowable().getStackTrace()) {
            if (this.packageName != null && !element.getClassName().contains(this.packageName)) continue;
            this.getConsumer().accept(exceptionReport);
            break;
        }
    }

    public String getPackageName() {
        return this.packageName;
    }
}

