/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.mayuslibrary.exceptionreporting;

import dev.mayuna.mayuslibrary.concurrent.event.EventBus;
import dev.mayuna.mayuslibrary.exceptionreporting.ExceptionReport;
import dev.mayuna.mayuslibrary.exceptionreporting.exceptions.ExceptionInExceptionReporterProcessing;

public class ExceptionReporter
extends EventBus<ExceptionReport>
implements Thread.UncaughtExceptionHandler {
    private static final ExceptionReporter instance = new ExceptionReporter();

    public static void registerExceptionReporter() {
        Thread.setDefaultUncaughtExceptionHandler(ExceptionReporter.getInstance());
        System.setProperty("sun.awt.exception.handler", ExceptionReporter.class.getName());
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        if (throwable instanceof ExceptionInExceptionReporterProcessing) {
            throwable.printStackTrace();
            return;
        }
        try {
            this.callAllListeners(new ExceptionReport(thread, throwable));
        }
        catch (Throwable exception) {
            throw new ExceptionInExceptionReporterProcessing("Another exception occurred while processing uncaught exception in ExceptionReporter!", throwable);
        }
    }

    public static ExceptionReporter getInstance() {
        return instance;
    }
}

