/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.mayuslibrary.graphics.console.colors;

import dev.mayuna.mayuslibrary.graphics.console.colors.Colors;

public class Color {
    public static String RESET = "\u001b[0m";
    private Colors foregroundColor = Colors.LIGHT_GRAY;
    private Colors backgroundColor = Colors.BLACK;
    private boolean isBold = false;
    private boolean hasUnderline = false;

    public boolean hasUnderline() {
        return this.hasUnderline;
    }

    public Color setBackground(Colors color) {
        this.backgroundColor = color;
        return this;
    }

    public Color setForeground(Colors color) {
        this.foregroundColor = color;
        return this;
    }

    public Color changeBold(boolean boldFlag) {
        this.isBold = boldFlag;
        return this;
    }

    public Color changeUnderline(boolean underlineFlag) {
        this.hasUnderline = underlineFlag;
        return this;
    }

    public String build() {
        String stringColor = "";
        stringColor = stringColor + "\u001b[" + this.foregroundColor.getColorNumber() + "m";
        stringColor = stringColor + "\u001b[" + (this.backgroundColor.getColorNumber() + 10) + "m";
        if (this.isBold) {
            stringColor = stringColor + "\u001b[1m";
        }
        if (this.hasUnderline) {
            stringColor = stringColor + "\u001b[4m";
        }
        return stringColor;
    }

    public String toString() {
        return this.build();
    }

    public Colors getForegroundColor() {
        return this.foregroundColor;
    }

    public Colors getBackgroundColor() {
        return this.backgroundColor;
    }

    public boolean isBold() {
        return this.isBold;
    }
}

