/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.mayuslibrary.logging;

import dev.mayuna.mayuslibrary.logging.LogPrefix;
import dev.mayuna.mayuslibrary.logging.Logger;
import dev.mayuna.mayuslibrary.logging.coloring.ColoringString;
import dev.mayuna.mayuslibrary.logging.types.BaseLogType;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class Log {
    private BaseLogType baseLogType;
    private String text;
    private Date date;
    private String className;
    private String methodName;
    private String threadName;
    private static Consumer<String> formattedLogBeforeColoring = string -> {};
    private static BiFunction<Log, String, String> customFormatConsumer = (log, string) -> string;

    public Log(String text) {
        this.text = text;
    }

    @Deprecated
    public Log(BaseLogType baseLogType, String text, Date date, String methodName, String threadName) {
        this.baseLogType = baseLogType;
        this.text = text;
        this.date = date;
        this.methodName = methodName;
        this.threadName = threadName;
    }

    public Log(BaseLogType baseLogType, String text, Date date, String className, String methodName, String threadName) {
        this.baseLogType = baseLogType;
        this.text = text;
        this.date = date;
        this.methodName = methodName;
        this.threadName = threadName;
        this.className = className;
    }

    public String getFormattedLog() {
        ColoringString coloringString = Logger.getColoring().getColoringForLogType(this.baseLogType);
        String formattedLog = this.getFormattedLogNoColors();
        formattedLogBeforeColoring.accept(formattedLog);
        if (coloringString != null) {
            formattedLog = coloringString.getColor() + formattedLog + coloringString.getResetColor();
        }
        return formattedLog;
    }

    public String getFormattedLogNoColors() {
        String formattedLog = Logger.getFormat();
        formattedLog = this.date != null ? formattedLog.replace("{time}", new SimpleDateFormat(Logger.getTimePattern()).format(this.date)) : formattedLog.replace("{time}", "");
        formattedLog = this.methodName != null && this.threadName != null ? formattedLog.replace("{method}", this.methodName).replace("{thread}", this.threadName) : formattedLog.replace("{method}", "").replace("{thread}", "");
        formattedLog = this.baseLogType != null ? formattedLog.replace("{type}", this.baseLogType.getName()) : formattedLog.replace("{type}", "");
        LogPrefix logPrefix = Logger.getLogPrefixByClassName(this.className);
        formattedLog = this.className != null && logPrefix != null ? formattedLog.replace("{prefix}", logPrefix.getPrefix()) : formattedLog.replace("{prefix}", "");
        formattedLog = formattedLog.replace("{text}", this.text);
        formattedLog = customFormatConsumer.apply(this, formattedLog);
        return formattedLog;
    }

    public String toString() {
        return "Log{logType=" + this.baseLogType + ", text='" + this.text + '\'' + ", date=" + this.date + ", methodName='" + this.methodName + '\'' + ", threadName='" + this.threadName + '\'' + '}';
    }

    public BaseLogType getBaseLogType() {
        return this.baseLogType;
    }

    public void setBaseLogType(BaseLogType baseLogType) {
        this.baseLogType = baseLogType;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public static Consumer<String> getFormattedLogBeforeColoring() {
        return formattedLogBeforeColoring;
    }

    public static void setFormattedLogBeforeColoring(Consumer<String> formattedLogBeforeColoring) {
        Log.formattedLogBeforeColoring = formattedLogBeforeColoring;
    }

    public static BiFunction<Log, String, String> getCustomFormatConsumer() {
        return customFormatConsumer;
    }

    public static void setCustomFormatConsumer(BiFunction<Log, String, String> customFormatConsumer) {
        Log.customFormatConsumer = customFormatConsumer;
    }
}

