/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.mayuslibrary.logging;

import dev.mayuna.mayuslibrary.logging.Log;
import dev.mayuna.mayuslibrary.logging.LogListener;
import dev.mayuna.mayuslibrary.logging.LogPrefix;
import dev.mayuna.mayuslibrary.logging.coloring.BaseColoring;
import dev.mayuna.mayuslibrary.logging.coloring.ColoringString;
import dev.mayuna.mayuslibrary.logging.coloring.ConsoleColoring;
import dev.mayuna.mayuslibrary.logging.types.BaseLogType;
import dev.mayuna.mayuslibrary.logging.types.DebugLogType;
import dev.mayuna.mayuslibrary.logging.types.ErrorLogType;
import dev.mayuna.mayuslibrary.logging.types.InfoLogType;
import dev.mayuna.mayuslibrary.logging.types.TraceLogType;
import dev.mayuna.mayuslibrary.logging.types.WarningLogType;
import dev.mayuna.mayuslibrary.util.ReflectionUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;

public class Logger {
    private static final List<LogListener> beforeLogListeners = new ArrayList<LogListener>();
    private static final List<LogListener> logListeners = new ArrayList<LogListener>();
    private static final List<Log> logs = new ArrayList<Log>();
    private static final List<LogPrefix> prefixes = new ArrayList<LogPrefix>();
    private static boolean saveLogsToList = false;
    private static boolean saveLogsToFile = false;
    private static String fileName = "log.txt";
    private static String timePattern = "HH:mm:ss.sss";
    private static String format = "[{time}][{method}/{thread}][{type}]:{prefix} {text}";
    private static BaseColoring coloring = new ConsoleColoring();
    public static Consumer<Log> printLogic = log -> System.out.println(log.getFormattedLog());
    public static int reflectionDepth = 4;

    public static void info(String text) {
        Logger.processLog(new InfoLogType(), text);
    }

    public static void warning(String text) {
        Logger.processLog(new WarningLogType(), text);
    }

    public static void error(String text) {
        Logger.processLog(new ErrorLogType(), text);
    }

    public static void debug(String text) {
        Logger.processLog(new DebugLogType(), text);
    }

    public static void trace(String text) {
        Logger.processLog(new TraceLogType(), text);
    }

    public static void custom(BaseLogType baseLogType, String text) {
        Logger.processLog(baseLogType, text);
    }

    public static void processLog(BaseLogType baseLogType, String text) {
        String methodName = ReflectionUtils.getMethodNameFromStack(reflectionDepth);
        String className = ReflectionUtils.getClassNameFromStack(reflectionDepth);
        Logger.processLog(new Log(baseLogType, text, new Date(System.currentTimeMillis()), className, methodName, Thread.currentThread().getName()));
    }

    public static void processLog(Log log) {
        beforeLogListeners.forEach(beforeLogListener -> beforeLogListener.getConsumer().accept(log));
        if (saveLogsToList) {
            logs.add(log);
        }
        if (saveLogsToFile) {
            try {
                Files.write(Paths.get(fileName, new String[0]), (log.getFormattedLogNoColors() + "\n").getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
            }
            catch (IOException exception) {
                throw new RuntimeException("Error occurred while writing log to file (" + fileName + ")!", exception);
            }
        }
        printLogic.accept(log);
        logListeners.forEach(logListener -> logListener.getConsumer().accept(log));
    }

    public static void addLogListener(LogListener logListener) {
        logListeners.add(logListener);
    }

    public static void removeLogListener(LogListener logListener) {
        logListeners.remove(logListener);
    }

    public static void removeLogListener(String name) {
        logListeners.remove(new LogListener(name, null));
    }

    public static void addBeforeLogListener(LogListener logListener) {
        beforeLogListeners.add(logListener);
    }

    public static void removeBeforeLogListener(LogListener logListener) {
        beforeLogListeners.remove(logListener);
    }

    public static void removeBeforeLogListener(String name) {
        beforeLogListeners.remove(new LogListener(name, null));
    }

    public static void addColoringString(ColoringString coloringString) {
        Logger.getColoring().addColoring(coloringString);
    }

    public static void addLogPrefix(LogPrefix logPrefix) {
        prefixes.add(logPrefix);
    }

    public static LogPrefix getLogPrefixByClassName(String className) {
        for (LogPrefix logPrefix : prefixes) {
            if (!logPrefix.getClazz().getName().equalsIgnoreCase(className)) continue;
            return logPrefix;
        }
        return null;
    }

    public static List<LogListener> getBeforeLogListeners() {
        return beforeLogListeners;
    }

    public static List<LogListener> getLogListeners() {
        return logListeners;
    }

    public static List<Log> getLogs() {
        return logs;
    }

    public static List<LogPrefix> getPrefixes() {
        return prefixes;
    }

    public static boolean isSaveLogsToList() {
        return saveLogsToList;
    }

    public static void setSaveLogsToList(boolean saveLogsToList) {
        Logger.saveLogsToList = saveLogsToList;
    }

    public static boolean isSaveLogsToFile() {
        return saveLogsToFile;
    }

    public static void setSaveLogsToFile(boolean saveLogsToFile) {
        Logger.saveLogsToFile = saveLogsToFile;
    }

    public static String getFileName() {
        return fileName;
    }

    public static void setFileName(String fileName) {
        Logger.fileName = fileName;
    }

    public static String getTimePattern() {
        return timePattern;
    }

    public static void setTimePattern(String timePattern) {
        Logger.timePattern = timePattern;
    }

    public static String getFormat() {
        return format;
    }

    public static void setFormat(String format) {
        Logger.format = format;
    }

    public static BaseColoring getColoring() {
        return coloring;
    }

    public static void setColoring(BaseColoring coloring) {
        Logger.coloring = coloring;
    }
}

