/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.mayuslibrary.util;

import java.lang.reflect.Method;

public class ReflectionUtils {
    public static String getMethodNameFromStack(int index) {
        try {
            return Thread.currentThread().getStackTrace()[index].getMethodName();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static String getClassNameFromStack(int index) {
        try {
            return Thread.currentThread().getStackTrace()[index].getClassName();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static Method getMethodFromStack(int index) {
        try {
            String methodName = ReflectionUtils.getMethodNameFromStack(index + 1);
            Class<?> clazz = ReflectionUtils.getClassFromStack(index + 2);
            return clazz.getMethod(methodName, new Class[0]);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static Class<?> getClassFromStack(int index) {
        try {
            String className = ReflectionUtils.getClassNameFromStack(index + 1);
            return Class.forName(className);
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

