/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.mayuslibrary.util;

import lombok.NonNull;

public class StringUtils {
    public static String capitalizeString(@NonNull String string, boolean skipNonAlphabeticCharacters, boolean capitalizeEvery, boolean normalize) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        if (normalize) {
            string = string.toLowerCase();
        }
        char[] charArray = string.toCharArray();
        for (int index = 0; index < charArray.length; ++index) {
            boolean shouldCapitalize = false;
            if (index == 0) {
                shouldCapitalize = true;
            } else if (charArray[index - 1] == ' ') {
                shouldCapitalize = true;
            }
            if (!shouldCapitalize || skipNonAlphabeticCharacters && !Character.isAlphabetic(charArray[index])) continue;
            StringUtils.setCharacter(string, Character.toUpperCase(charArray[index]), index);
            if (capitalizeEvery) continue;
            return string;
        }
        return string;
    }

    public static String prettyStringFirstLetter(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        return StringUtils.capitalizeString(string, true, false, true);
    }

    public static String prettyStringEveryLetter(String string) {
        return StringUtils.capitalizeString(string, true, true, true);
    }

    public static boolean startsWithAny(String string, String[] prefixes) {
        for (String prefix : prefixes) {
            if (!string.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static String replaceAny(String string, String[] regexes, String replacement) {
        for (String regex : regexes) {
            string = string.replaceAll(regex, replacement);
        }
        return string;
    }

    public static String setCharacter(String string, char character, int index) {
        char[] chars = string.toCharArray();
        chars[index] = character;
        return String.valueOf(chars);
    }
}

