/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.mayuslibrary.util.objects;

public class ParsedStackTraceElement {
    private final StackTraceElement stackTraceElement;
    private String className;

    public ParsedStackTraceElement(StackTraceElement stackTraceElement) {
        this.stackTraceElement = stackTraceElement;
        this.parse();
    }

    private void parse() {
        String fullClassName = this.getFullyQualifiedClassName();
        this.className = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
    }

    public String getFullyQualifiedClassName() {
        return this.stackTraceElement.getClassName();
    }

    public String getMethodName() {
        return this.stackTraceElement.getMethodName();
    }

    public String getFileName() {
        return this.stackTraceElement.getFileName();
    }

    public int getLineNumber() {
        return this.stackTraceElement.getLineNumber();
    }

    public boolean isNativeMethod() {
        return this.stackTraceElement.isNativeMethod();
    }

    public StackTraceElement getStackTraceElement() {
        return this.stackTraceElement;
    }

    public String getClassName() {
        return this.className;
    }
}

