/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.mayuslibrary.exceptionreporting;

import dev.mayuna.mayuslibrary.exceptionreporting.ExceptionReport;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import lombok.NonNull;

public final class UncaughtExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private static final UncaughtExceptionReporter instance = new UncaughtExceptionReporter();
    private static final List<Consumer<ExceptionReport>> exceptionReportConsumers = new LinkedList<Consumer<ExceptionReport>>();

    public static void register() {
        Thread.setDefaultUncaughtExceptionHandler(UncaughtExceptionReporter.getInstance());
        System.setProperty("sun.awt.exception.handler", UncaughtExceptionReporter.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addExceptionReportConsumer(@NonNull Consumer<ExceptionReport> exceptionReportConsumer) {
        if (exceptionReportConsumer == null) {
            throw new NullPointerException("exceptionReportConsumer is marked non-null but is null");
        }
        List<Consumer<ExceptionReport>> list = exceptionReportConsumers;
        synchronized (list) {
            return exceptionReportConsumers.add(exceptionReportConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeExceptionReportConsumer(@NonNull Consumer<ExceptionReport> exceptionReportConsumer) {
        if (exceptionReportConsumer == null) {
            throw new NullPointerException("exceptionReportConsumer is marked non-null but is null");
        }
        List<Consumer<ExceptionReport>> list = exceptionReportConsumers;
        synchronized (list) {
            return exceptionReportConsumers.remove(exceptionReportConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        ExceptionReport exceptionReport = new ExceptionReport(thread, throwable);
        List<Consumer<ExceptionReport>> list = exceptionReportConsumers;
        synchronized (list) {
            exceptionReportConsumers.forEach(consumer -> consumer.accept(exceptionReport));
        }
    }

    public static UncaughtExceptionReporter getInstance() {
        return instance;
    }
}

