/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.mayuslibrary.util;

public final class StackUtils {
    private StackUtils() {
    }

    public static StackTraceElement getStackTraceElementByIndex(int index) {
        return Thread.currentThread().getStackTrace()[index];
    }

    public static StackTraceElement getCallerStackTraceElement() {
        return StackUtils.getStackTraceElementByIndex(3);
    }

    public static String getClassMethodNameFromStack(int index) {
        StackTraceElement stackTraceElement = StackUtils.getStackTraceElementByIndex(index);
        return StackUtils.getLastElementOfClassHierarchy(stackTraceElement.getClassName()) + "#" + stackTraceElement.getMethodName() + "()";
    }

    private static String getLastElementOfClassHierarchy(String className) {
        return className.substring(className.lastIndexOf(".") + 1);
    }
}

