/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.mayuslibrary.util;

import dev.mayuna.mayuslibrary.util.StringCapitalizeStrategy;
import lombok.NonNull;

public final class StringUtils {
    private StringUtils() {
    }

    public static String capitalizeString(@NonNull String string, @NonNull StringCapitalizeStrategy stringCapitalizeStrategy, boolean skipNonAlphabeticCharacters) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        if (stringCapitalizeStrategy == null) {
            throw new NullPointerException("stringCapitalizeStrategy is marked non-null but is null");
        }
        if (string.isEmpty()) {
            return string;
        }
        string = string.toLowerCase();
        if (stringCapitalizeStrategy == StringCapitalizeStrategy.FIRST_LETTER_ONLY) {
            int letterIndex = -1;
            if (skipNonAlphabeticCharacters) {
                for (int i = 0; i < string.length(); ++i) {
                    char ch = string.charAt(i);
                    if (!Character.isLetter(ch)) continue;
                    letterIndex = i;
                    break;
                }
                if (letterIndex == -1) {
                    return string;
                }
            } else {
                letterIndex = 0;
            }
            char[] charArray = string.toCharArray();
            charArray[letterIndex] = Character.toUpperCase(charArray[letterIndex]);
            return new String(charArray);
        }
        StringBuilder sb = new StringBuilder();
        boolean capitalizeNext = true;
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (Character.isWhitespace(ch)) {
                sb.append(ch);
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext && Character.isLetter(ch)) {
                sb.append(Character.toUpperCase(ch));
                capitalizeNext = false;
                continue;
            }
            sb.append(ch);
            if (skipNonAlphabeticCharacters) continue;
            capitalizeNext = false;
        }
        return sb.toString();
    }

    public static String capitalizeString(@NonNull String string, @NonNull StringCapitalizeStrategy stringCapitalizeStrategy) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        if (stringCapitalizeStrategy == null) {
            throw new NullPointerException("stringCapitalizeStrategy is marked non-null but is null");
        }
        return StringUtils.capitalizeString(string, stringCapitalizeStrategy, true);
    }

    public static boolean startsWithAny(@NonNull String string, @NonNull String[] prefixes) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        if (prefixes == null) {
            throw new NullPointerException("prefixes is marked non-null but is null");
        }
        for (String prefix : prefixes) {
            if (!string.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static String replaceAny(@NonNull String string, @NonNull String[] regexes, @NonNull String replacement) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        if (regexes == null) {
            throw new NullPointerException("regexes is marked non-null but is null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement is marked non-null but is null");
        }
        for (String regex : regexes) {
            string = string.replaceAll(regex, replacement);
        }
        return string;
    }

    public static int countMatches(@NonNull String string, @NonNull String subString) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        if (subString == null) {
            throw new NullPointerException("subString is marked non-null but is null");
        }
        if (string.isEmpty() || subString.isEmpty()) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = string.indexOf(subString, idx)) != -1) {
            ++count;
            idx += subString.length();
        }
        return count;
    }
}

