/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.base;

import dev.mccue.guava.base.CharMatcher;
import dev.mccue.guava.base.CommonPattern;
import dev.mccue.guava.base.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.base.Enums;
import dev.mccue.guava.base.JdkPattern;
import dev.mccue.guava.base.Optional;
import dev.mccue.guava.base.PatternCompiler;
import dev.mccue.guava.base.Preconditions;
import dev.mccue.jsr305.CheckForNull;
import java.lang.ref.WeakReference;
import java.util.Locale;
import java.util.ServiceConfigurationError;
import java.util.regex.Pattern;

@ElementTypesAreNonnullByDefault
final class Platform {
    private static final System.Logger logger = System.getLogger(Platform.class.getName());
    private static final PatternCompiler patternCompiler = Platform.loadPatternCompiler();

    private Platform() {
    }

    static CharMatcher precomputeCharMatcher(CharMatcher matcher) {
        return matcher.precomputedInternal();
    }

    static <T extends Enum<T>> Optional<T> getEnumIfPresent(Class<T> enumClass, String value) {
        WeakReference<Enum<?>> ref = Enums.getEnumConstants(enumClass).get(value);
        return ref == null ? Optional.absent() : Optional.of((Enum)enumClass.cast(ref.get()));
    }

    static String formatCompact4Digits(double value) {
        return String.format(Locale.ROOT, "%.4g", value);
    }

    static boolean stringIsNullOrEmpty(@CheckForNull String string) {
        return string == null || string.isEmpty();
    }

    static String nullToEmpty(@CheckForNull String string) {
        return string == null ? "" : string;
    }

    @CheckForNull
    static String emptyToNull(@CheckForNull String string) {
        return Platform.stringIsNullOrEmpty(string) ? null : string;
    }

    static CommonPattern compilePattern(String pattern) {
        Preconditions.checkNotNull(pattern);
        return patternCompiler.compile(pattern);
    }

    static boolean patternCompilerIsPcreLike() {
        return patternCompiler.isPcreLike();
    }

    private static PatternCompiler loadPatternCompiler() {
        return new JdkPatternCompiler();
    }

    private static void logPatternCompilerError(ServiceConfigurationError e) {
        logger.log(System.Logger.Level.WARNING, "Error loading regex compiler, falling back to next option", (Throwable)e);
    }

    private static final class JdkPatternCompiler
    implements PatternCompiler {
        private JdkPatternCompiler() {
        }

        @Override
        public CommonPattern compile(String pattern) {
            return new JdkPattern(Pattern.compile(pattern));
        }

        @Override
        public boolean isPcreLike() {
            return true;
        }
    }
}

