/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.base;

import dev.mccue.guava.base.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.base.Function;
import dev.mccue.guava.base.Optional;
import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.base.Supplier;
import dev.mccue.jsr305.CheckForNull;
import java.util.Collections;
import java.util.Set;

@ElementTypesAreNonnullByDefault
final class Absent<T>
extends Optional<T> {
    static final Absent<Object> INSTANCE = new Absent();
    private static final long serialVersionUID = 0L;

    static <T> Optional<T> withType() {
        return INSTANCE;
    }

    private Absent() {
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @Override
    public T get() {
        throw new IllegalStateException("Optional.get() cannot be called on an absent value");
    }

    @Override
    public T or(T defaultValue) {
        return Preconditions.checkNotNull(defaultValue, "use Optional.orNull() instead of Optional.or(null)");
    }

    @Override
    public Optional<T> or(Optional<? extends T> secondChoice) {
        return Preconditions.checkNotNull(secondChoice);
    }

    @Override
    public T or(Supplier<? extends T> supplier) {
        return Preconditions.checkNotNull(supplier.get(), "use Optional.orNull() instead of a Supplier that returns null");
    }

    @Override
    @CheckForNull
    public T orNull() {
        return null;
    }

    @Override
    public Set<T> asSet() {
        return Collections.emptySet();
    }

    @Override
    public <V> Optional<V> transform(Function<? super T, V> function) {
        Preconditions.checkNotNull(function);
        return Optional.absent();
    }

    @Override
    public boolean equals(@CheckForNull Object object) {
        return object == this;
    }

    @Override
    public int hashCode() {
        return 2040732332;
    }

    @Override
    public String toString() {
        return "Optional.absent()";
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

