/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.base;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.mccue.guava.base.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.base.NullnessCasts;
import dev.mccue.guava.base.ParametricNullness;
import dev.mccue.guava.base.Preconditions;
import dev.mccue.jsr305.CheckForNull;
import java.util.Iterator;
import java.util.NoSuchElementException;

@ElementTypesAreNonnullByDefault
abstract class AbstractIterator<T>
implements Iterator<T> {
    private State state = State.NOT_READY;
    @CheckForNull
    private T next;

    protected AbstractIterator() {
    }

    @CheckForNull
    protected abstract T computeNext();

    @CheckForNull
    @CanIgnoreReturnValue
    protected final T endOfData() {
        this.state = State.DONE;
        return null;
    }

    @Override
    public final boolean hasNext() {
        Preconditions.checkState(this.state != State.FAILED);
        switch (this.state) {
            case DONE: {
                return false;
            }
            case READY: {
                return true;
            }
        }
        return this.tryToComputeNext();
    }

    private boolean tryToComputeNext() {
        this.state = State.FAILED;
        this.next = this.computeNext();
        if (this.state != State.DONE) {
            this.state = State.READY;
            return true;
        }
        return false;
    }

    @Override
    @ParametricNullness
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        T result = NullnessCasts.uncheckedCastNullableTToT(this.next);
        this.next = null;
        return result;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    private static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }
}

