/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.collect;

import dev.mccue.guava.base.Objects;
import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.base.Predicate;
import dev.mccue.guava.base.Predicates;
import dev.mccue.guava.collect.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.collect.FilteredMultimap;
import dev.mccue.guava.collect.Iterables;
import dev.mccue.guava.collect.Maps;
import dev.mccue.jsr305.CheckForNull;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

@ElementTypesAreNonnullByDefault
final class FilteredMultimapValues<K, V>
extends AbstractCollection<V> {
    private final FilteredMultimap<K, V> multimap;

    FilteredMultimapValues(FilteredMultimap<K, V> multimap) {
        this.multimap = (FilteredMultimap)Preconditions.checkNotNull(multimap);
    }

    @Override
    public Iterator<V> iterator() {
        return Maps.valueIterator(this.multimap.entries().iterator());
    }

    @Override
    public boolean contains(@CheckForNull Object o) {
        return this.multimap.containsValue(o);
    }

    @Override
    public int size() {
        return this.multimap.size();
    }

    @Override
    public boolean remove(@CheckForNull Object o) {
        Predicate<Map.Entry<K, V>> entryPredicate = this.multimap.entryPredicate();
        Iterator<Map.Entry<K, V>> unfilteredItr = this.multimap.unfiltered().entries().iterator();
        while (unfilteredItr.hasNext()) {
            Map.Entry<K, V> entry = unfilteredItr.next();
            if (!entryPredicate.apply(entry) || !Objects.equal(entry.getValue(), (Object)o)) continue;
            unfilteredItr.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return Iterables.removeIf(this.multimap.unfiltered().entries(), Predicates.and(this.multimap.entryPredicate(), Maps.valuePredicateOnEntries(Predicates.in(c))));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return Iterables.removeIf(this.multimap.unfiltered().entries(), Predicates.and(this.multimap.entryPredicate(), Maps.valuePredicateOnEntries(Predicates.not((Predicate)Predicates.in(c)))));
    }

    @Override
    public void clear() {
        this.multimap.clear();
    }
}

