/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.collect;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.collect.AbstractBiMap;
import dev.mccue.guava.collect.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.collect.EnumBiMap;
import dev.mccue.guava.collect.ParametricNullness;
import dev.mccue.guava.collect.Serialization;
import dev.mccue.jsr305.CheckForNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ElementTypesAreNonnullByDefault
public final class EnumHashBiMap<K extends Enum<K>, V>
extends AbstractBiMap<K, V> {
    transient Class<K> keyTypeOrObjectUnderJ2cl;
    private static final long serialVersionUID = 0L;

    public static <K extends Enum<K>, V> EnumHashBiMap<K, V> create(Class<K> keyType) {
        return new EnumHashBiMap<K, V>(keyType);
    }

    public static <K extends Enum<K>, V> EnumHashBiMap<K, V> create(Map<K, ? extends V> map) {
        EnumHashBiMap<K, V> bimap = EnumHashBiMap.create(EnumBiMap.inferKeyTypeOrObjectUnderJ2cl(map));
        bimap.putAll((Map)map);
        return bimap;
    }

    private EnumHashBiMap(Class<K> keyType) {
        super(new EnumMap(keyType), new HashMap());
        this.keyTypeOrObjectUnderJ2cl = keyType;
    }

    @Override
    K checkKey(K key) {
        return (K)((Enum)Preconditions.checkNotNull(key));
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V put(K key, @ParametricNullness V value) {
        return super.put(key, value);
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V forcePut(K key, @ParametricNullness V value) {
        return super.forcePut(key, value);
    }

    public Class<K> keyType() {
        return this.keyTypeOrObjectUnderJ2cl;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.keyTypeOrObjectUnderJ2cl);
        Serialization.writeMap(this, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.keyTypeOrObjectUnderJ2cl = (Class)Objects.requireNonNull(stream.readObject());
        this.setDelegates(new EnumMap(this.keyTypeOrObjectUnderJ2cl), new HashMap());
        Serialization.populateMap(this, stream);
    }
}

