/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.collect;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.mccue.guava.base.Ascii;
import dev.mccue.guava.base.Equivalence;
import dev.mccue.guava.base.MoreObjects;
import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.collect.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.collect.MapMakerInternalMap;
import dev.mccue.jsr305.CheckForNull;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@ElementTypesAreNonnullByDefault
public final class MapMaker {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 4;
    static final int UNSET_INT = -1;
    boolean useCustomMap;
    int initialCapacity = -1;
    int concurrencyLevel = -1;
    @CheckForNull
    MapMakerInternalMap.Strength keyStrength;
    @CheckForNull
    MapMakerInternalMap.Strength valueStrength;
    @CheckForNull
    Equivalence<Object> keyEquivalence;

    @CanIgnoreReturnValue
    MapMaker keyEquivalence(Equivalence<Object> equivalence) {
        Preconditions.checkState((this.keyEquivalence == null ? 1 : 0) != 0, (String)"key equivalence was already set to %s", this.keyEquivalence);
        this.keyEquivalence = (Equivalence)Preconditions.checkNotNull(equivalence);
        this.useCustomMap = true;
        return this;
    }

    Equivalence<Object> getKeyEquivalence() {
        return (Equivalence)MoreObjects.firstNonNull(this.keyEquivalence, this.getKeyStrength().defaultEquivalence());
    }

    @CanIgnoreReturnValue
    public MapMaker initialCapacity(int initialCapacity) {
        Preconditions.checkState((this.initialCapacity == -1 ? 1 : 0) != 0, (String)"initial capacity was already set to %s", (int)this.initialCapacity);
        Preconditions.checkArgument((initialCapacity >= 0 ? 1 : 0) != 0);
        this.initialCapacity = initialCapacity;
        return this;
    }

    int getInitialCapacity() {
        return this.initialCapacity == -1 ? 16 : this.initialCapacity;
    }

    @CanIgnoreReturnValue
    public MapMaker concurrencyLevel(int concurrencyLevel) {
        Preconditions.checkState((this.concurrencyLevel == -1 ? 1 : 0) != 0, (String)"concurrency level was already set to %s", (int)this.concurrencyLevel);
        Preconditions.checkArgument((concurrencyLevel > 0 ? 1 : 0) != 0);
        this.concurrencyLevel = concurrencyLevel;
        return this;
    }

    int getConcurrencyLevel() {
        return this.concurrencyLevel == -1 ? 4 : this.concurrencyLevel;
    }

    @CanIgnoreReturnValue
    public MapMaker weakKeys() {
        return this.setKeyStrength(MapMakerInternalMap.Strength.WEAK);
    }

    MapMaker setKeyStrength(MapMakerInternalMap.Strength strength) {
        Preconditions.checkState((this.keyStrength == null ? 1 : 0) != 0, (String)"Key strength was already set to %s", (Object)((Object)this.keyStrength));
        this.keyStrength = (MapMakerInternalMap.Strength)((Object)Preconditions.checkNotNull((Object)((Object)strength)));
        if (strength != MapMakerInternalMap.Strength.STRONG) {
            this.useCustomMap = true;
        }
        return this;
    }

    MapMakerInternalMap.Strength getKeyStrength() {
        return (MapMakerInternalMap.Strength)((Object)MoreObjects.firstNonNull((Object)((Object)this.keyStrength), (Object)((Object)MapMakerInternalMap.Strength.STRONG)));
    }

    @CanIgnoreReturnValue
    public MapMaker weakValues() {
        return this.setValueStrength(MapMakerInternalMap.Strength.WEAK);
    }

    MapMaker setValueStrength(MapMakerInternalMap.Strength strength) {
        Preconditions.checkState((this.valueStrength == null ? 1 : 0) != 0, (String)"Value strength was already set to %s", (Object)((Object)this.valueStrength));
        this.valueStrength = (MapMakerInternalMap.Strength)((Object)Preconditions.checkNotNull((Object)((Object)strength)));
        if (strength != MapMakerInternalMap.Strength.STRONG) {
            this.useCustomMap = true;
        }
        return this;
    }

    MapMakerInternalMap.Strength getValueStrength() {
        return (MapMakerInternalMap.Strength)((Object)MoreObjects.firstNonNull((Object)((Object)this.valueStrength), (Object)((Object)MapMakerInternalMap.Strength.STRONG)));
    }

    public <K, V> ConcurrentMap<K, V> makeMap() {
        if (!this.useCustomMap) {
            return new ConcurrentHashMap(this.getInitialCapacity(), 0.75f, this.getConcurrencyLevel());
        }
        return MapMakerInternalMap.create(this);
    }

    public String toString() {
        MoreObjects.ToStringHelper s = MoreObjects.toStringHelper((Object)this);
        if (this.initialCapacity != -1) {
            s.add("initialCapacity", this.initialCapacity);
        }
        if (this.concurrencyLevel != -1) {
            s.add("concurrencyLevel", this.concurrencyLevel);
        }
        if (this.keyStrength != null) {
            s.add("keyStrength", (Object)Ascii.toLowerCase((String)this.keyStrength.toString()));
        }
        if (this.valueStrength != null) {
            s.add("valueStrength", (Object)Ascii.toLowerCase((String)this.valueStrength.toString()));
        }
        if (this.keyEquivalence != null) {
            s.addValue((Object)"keyEquivalence");
        }
        return s.toString();
    }

    static enum Dummy {
        VALUE;

    }
}

