/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.collect;

import com.google.errorprone.annotations.concurrent.LazyInit;
import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.collect.CollectPreconditions;
import dev.mccue.guava.collect.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.collect.ImmutableBiMap;
import dev.mccue.guava.collect.ImmutableSet;
import dev.mccue.guava.collect.Maps;
import dev.mccue.jsr305.CheckForNull;
import java.util.Map;
import java.util.function.BiConsumer;

@ElementTypesAreNonnullByDefault
final class SingletonImmutableBiMap<K, V>
extends ImmutableBiMap<K, V> {
    final transient K singleKey;
    final transient V singleValue;
    @CheckForNull
    private final transient ImmutableBiMap<V, K> inverse;
    @LazyInit
    @CheckForNull
    private transient ImmutableBiMap<V, K> lazyInverse;

    SingletonImmutableBiMap(K singleKey, V singleValue) {
        CollectPreconditions.checkEntryNotNull(singleKey, singleValue);
        this.singleKey = singleKey;
        this.singleValue = singleValue;
        this.inverse = null;
    }

    private SingletonImmutableBiMap(K singleKey, V singleValue, ImmutableBiMap<V, K> inverse) {
        this.singleKey = singleKey;
        this.singleValue = singleValue;
        this.inverse = inverse;
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull Object key) {
        return this.singleKey.equals(key) ? (V)this.singleValue : null;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        ((BiConsumer)Preconditions.checkNotNull(action)).accept(this.singleKey, this.singleValue);
    }

    @Override
    public boolean containsKey(@CheckForNull Object key) {
        return this.singleKey.equals(key);
    }

    @Override
    public boolean containsValue(@CheckForNull Object value) {
        return this.singleValue.equals(value);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return ImmutableSet.of(Maps.immutableEntry(this.singleKey, this.singleValue));
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return ImmutableSet.of(this.singleKey);
    }

    @Override
    public ImmutableBiMap<V, K> inverse() {
        if (this.inverse != null) {
            return this.inverse;
        }
        ImmutableBiMap<V, K> result = this.lazyInverse;
        if (result == null) {
            this.lazyInverse = new SingletonImmutableBiMap<K, V>(this.singleValue, this.singleKey, this);
            return this.lazyInverse;
        }
        return result;
    }

    @Override
    Object writeReplace() {
        return super.writeReplace();
    }
}

