/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.concurrent;

import com.google.errorprone.annotations.ForOverride;
import dev.mccue.guava.base.Function;
import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.concurrent.AsyncFunction;
import dev.mccue.guava.concurrent.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.concurrent.FluentFuture;
import dev.mccue.guava.concurrent.Futures;
import dev.mccue.guava.concurrent.ListenableFuture;
import dev.mccue.guava.concurrent.MoreExecutors;
import dev.mccue.guava.concurrent.NullnessCasts;
import dev.mccue.guava.concurrent.ParametricNullness;
import dev.mccue.guava.concurrent.Platform;
import dev.mccue.guava.concurrent.internal.InternalFutureFailureAccess;
import dev.mccue.guava.concurrent.internal.InternalFutures;
import dev.mccue.jsr305.CheckForNull;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

@ElementTypesAreNonnullByDefault
abstract class AbstractCatchingFuture<V, X extends Throwable, F, T>
extends FluentFuture.TrustedFuture<V>
implements Runnable {
    @CheckForNull
    ListenableFuture<? extends V> inputFuture;
    @CheckForNull
    Class<X> exceptionType;
    @CheckForNull
    F fallback;

    static <V, X extends Throwable> ListenableFuture<V> create(ListenableFuture<? extends V> input, Class<X> exceptionType, Function<? super X, ? extends V> fallback, Executor executor) {
        CatchingFuture<? extends V, ? super X> future = new CatchingFuture<V, X>(input, exceptionType, fallback);
        input.addListener(future, MoreExecutors.rejectionPropagatingExecutor(executor, future));
        return future;
    }

    static <X extends Throwable, V> ListenableFuture<V> create(ListenableFuture<? extends V> input, Class<X> exceptionType, AsyncFunction<? super X, ? extends V> fallback, Executor executor) {
        AsyncCatchingFuture<? extends V, ? super X> future = new AsyncCatchingFuture<V, X>(input, exceptionType, fallback);
        input.addListener(future, MoreExecutors.rejectionPropagatingExecutor(executor, future));
        return future;
    }

    AbstractCatchingFuture(ListenableFuture<? extends V> inputFuture, Class<X> exceptionType, F fallback) {
        this.inputFuture = (ListenableFuture)Preconditions.checkNotNull(inputFuture);
        this.exceptionType = (Class)Preconditions.checkNotNull(exceptionType);
        this.fallback = Preconditions.checkNotNull(fallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        T fallbackResult;
        F localFallback;
        Class<X> localExceptionType;
        ListenableFuture<V> localInputFuture = this.inputFuture;
        if (localInputFuture == null | (localExceptionType = this.exceptionType) == null | (localFallback = this.fallback) == null || this.isCancelled()) {
            return;
        }
        this.inputFuture = null;
        Object sourceResult = null;
        Throwable throwable = null;
        try {
            if (localInputFuture instanceof InternalFutureFailureAccess) {
                throwable = InternalFutures.tryInternalFastPathGetFailure((InternalFutureFailureAccess)((Object)localInputFuture));
            }
            if (throwable == null) {
                sourceResult = Futures.getDone(localInputFuture);
            }
        }
        catch (ExecutionException e) {
            throwable = e.getCause();
            if (throwable == null) {
                throwable = new NullPointerException("Future type " + localInputFuture.getClass() + " threw " + e.getClass() + " without a cause");
            }
        }
        catch (Error | RuntimeException e) {
            throwable = e;
        }
        if (throwable == null) {
            this.set(NullnessCasts.uncheckedCastNullableTToT(sourceResult));
            return;
        }
        if (!Platform.isInstanceOfThrowableClass(throwable, localExceptionType)) {
            this.setFuture(localInputFuture);
            return;
        }
        Throwable castThrowable = throwable;
        try {
            fallbackResult = this.doFallback(localFallback, castThrowable);
        }
        catch (Throwable t) {
            Platform.restoreInterruptIfIsInterruptedException(t);
            this.setException(t);
            return;
        }
        finally {
            this.exceptionType = null;
            this.fallback = null;
        }
        this.setResult(fallbackResult);
    }

    @Override
    @CheckForNull
    protected String pendingToString() {
        ListenableFuture<? extends V> localInputFuture = this.inputFuture;
        Class<X> localExceptionType = this.exceptionType;
        F localFallback = this.fallback;
        String superString = super.pendingToString();
        Object resultString = "";
        if (localInputFuture != null) {
            resultString = "inputFuture=[" + localInputFuture + "], ";
        }
        if (localExceptionType != null && localFallback != null) {
            return (String)resultString + "exceptionType=[" + localExceptionType + "], fallback=[" + localFallback + "]";
        }
        if (superString != null) {
            return (String)resultString + superString;
        }
        return null;
    }

    @ParametricNullness
    @ForOverride
    abstract T doFallback(F var1, X var2) throws Exception;

    @ForOverride
    abstract void setResult(@ParametricNullness T var1);

    @Override
    protected final void afterDone() {
        this.maybePropagateCancellationTo(this.inputFuture);
        this.inputFuture = null;
        this.exceptionType = null;
        this.fallback = null;
    }

    private static final class CatchingFuture<V, X extends Throwable>
    extends AbstractCatchingFuture<V, X, Function<? super X, ? extends V>, V> {
        CatchingFuture(ListenableFuture<? extends V> input, Class<X> exceptionType, Function<? super X, ? extends V> fallback) {
            super(input, exceptionType, fallback);
        }

        @Override
        @ParametricNullness
        V doFallback(Function<? super X, ? extends V> fallback, X cause) throws Exception {
            return (V)fallback.apply(cause);
        }

        @Override
        void setResult(@ParametricNullness V result) {
            this.set(result);
        }
    }

    private static final class AsyncCatchingFuture<V, X extends Throwable>
    extends AbstractCatchingFuture<V, X, AsyncFunction<? super X, ? extends V>, ListenableFuture<? extends V>> {
        AsyncCatchingFuture(ListenableFuture<? extends V> input, Class<X> exceptionType, AsyncFunction<? super X, ? extends V> fallback) {
            super(input, exceptionType, fallback);
        }

        @Override
        ListenableFuture<? extends V> doFallback(AsyncFunction<? super X, ? extends V> fallback, X cause) throws Exception {
            ListenableFuture<? extends V> replacement = fallback.apply(cause);
            Preconditions.checkNotNull(replacement, (String)"AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)? %s", fallback);
            return replacement;
        }

        @Override
        void setResult(ListenableFuture<? extends V> result) {
            this.setFuture(result);
        }
    }
}

