/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.concurrent;

import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.base.Supplier;
import dev.mccue.guava.concurrent.AsyncCallable;
import dev.mccue.guava.concurrent.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.concurrent.ListeningExecutorService;
import dev.mccue.guava.concurrent.ParametricNullness;
import java.util.concurrent.Callable;

@ElementTypesAreNonnullByDefault
public final class Callables {
    private Callables() {
    }

    public static <T> Callable<T> returning(@ParametricNullness T value) {
        return () -> value;
    }

    public static <T> AsyncCallable<T> asAsyncCallable(Callable<T> callable, ListeningExecutorService listeningExecutorService) {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull((Object)listeningExecutorService);
        return () -> listeningExecutorService.submit(callable);
    }

    static <T> Callable<T> threadRenaming(Callable<T> callable, Supplier<String> nameSupplier) {
        Preconditions.checkNotNull(nameSupplier);
        Preconditions.checkNotNull(callable);
        return () -> {
            Thread currentThread = Thread.currentThread();
            String oldName = currentThread.getName();
            boolean restoreName = Callables.trySetName((String)nameSupplier.get(), currentThread);
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                if (restoreName) {
                    boolean bl = Callables.trySetName(oldName, currentThread);
                }
            }
        };
    }

    static Runnable threadRenaming(Runnable task, Supplier<String> nameSupplier) {
        Preconditions.checkNotNull(nameSupplier);
        Preconditions.checkNotNull((Object)task);
        return () -> {
            Thread currentThread = Thread.currentThread();
            String oldName = currentThread.getName();
            boolean restoreName = Callables.trySetName((String)nameSupplier.get(), currentThread);
            try {
                task.run();
            }
            finally {
                if (restoreName) {
                    boolean bl = Callables.trySetName(oldName, currentThread);
                }
            }
        };
    }

    private static boolean trySetName(String threadName, Thread currentThread) {
        try {
            currentThread.setName(threadName);
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }
}

