/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.concurrent;

import dev.mccue.guava.collect.ImmutableCollection;
import dev.mccue.guava.collect.Lists;
import dev.mccue.guava.concurrent.AggregateFuture;
import dev.mccue.guava.concurrent.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.concurrent.ListenableFuture;
import dev.mccue.guava.concurrent.ParametricNullness;
import dev.mccue.jsr305.CheckForNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
abstract class CollectionFuture<V, C>
extends AggregateFuture<V, C> {
    @CheckForNull
    private List<@Nullable Present<V>> values;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    CollectionFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
        super(futures, allMustSucceed, true);
        @Nullable ArrayList values = futures.isEmpty() ? Collections.emptyList() : Lists.newArrayListWithCapacity((int)futures.size());
        for (int i = 0; i < futures.size(); ++i) {
            values.add(null);
        }
        this.values = values;
    }

    @Override
    final void collectOneValue(int index, @ParametricNullness V returnValue) {
        List<@Nullable Present<V>> localValues = this.values;
        if (localValues != null) {
            localValues.set(index, new Present<V>(returnValue));
        }
    }

    @Override
    final void handleAllCompleted() {
        List<@Nullable Present<V>> localValues = this.values;
        if (localValues != null) {
            this.set(this.combine(localValues));
        }
    }

    @Override
    void releaseResources(AggregateFuture.ReleaseResourcesReason reason) {
        super.releaseResources(reason);
        this.values = null;
    }

    abstract C combine(List<@Nullable Present<V>> var1);

    private static final class Present<V> {
        @ParametricNullness
        final V value;

        Present(@ParametricNullness V value) {
            this.value = value;
        }
    }

    static final class ListFuture<V>
    extends CollectionFuture<V, List<V>> {
        ListFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
            super(futures, allMustSucceed);
            this.init();
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public List<@Nullable V> combine(List<@Nullable Present<V>> values) {
            @Nullable ArrayList result = Lists.newArrayListWithCapacity((int)values.size());
            for (Present<V> element : values) {
                result.add(element != null ? (Object)element.value : null);
            }
            return Collections.unmodifiableList(result);
        }
    }
}

