/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.concurrent;

import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.concurrent.AbstractFuture;
import dev.mccue.guava.concurrent.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.concurrent.ListenableFuture;
import dev.mccue.guava.concurrent.ParametricNullness;
import dev.mccue.jsr305.CheckForNull;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@ElementTypesAreNonnullByDefault
class ImmediateFuture<V>
implements ListenableFuture<V> {
    static final ListenableFuture<?> NULL = new ImmediateFuture<Object>(null);
    private static final System.Logger log = System.getLogger(ImmediateFuture.class.getName());
    @ParametricNullness
    private final V value;

    ImmediateFuture(@ParametricNullness V value) {
        this.value = value;
    }

    @Override
    public void addListener(Runnable listener, Executor executor) {
        Preconditions.checkNotNull((Object)listener, (Object)"Runnable was null.");
        Preconditions.checkNotNull((Object)executor, (Object)"Executor was null.");
        try {
            executor.execute(listener);
        }
        catch (RuntimeException e) {
            log.log(System.Logger.Level.ERROR, "RuntimeException while executing runnable " + listener + " with executor " + executor, (Throwable)e);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    @ParametricNullness
    public V get() {
        return this.value;
    }

    @Override
    @ParametricNullness
    public V get(long timeout, TimeUnit unit) throws ExecutionException {
        Preconditions.checkNotNull((Object)((Object)unit));
        return this.get();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    public String toString() {
        return super.toString() + "[status=SUCCESS, result=[" + this.value + "]]";
    }

    static final class ImmediateCancelledFuture<V>
    extends AbstractFuture.TrustedFuture<V> {
        @CheckForNull
        static final ImmediateCancelledFuture<Object> INSTANCE = AbstractFuture.GENERATE_CANCELLATION_CAUSES ? null : new ImmediateCancelledFuture();

        ImmediateCancelledFuture() {
            this.cancel(false);
        }
    }

    static final class ImmediateFailedFuture<V>
    extends AbstractFuture.TrustedFuture<V> {
        ImmediateFailedFuture(Throwable thrown) {
            this.setException(thrown);
        }
    }
}

