/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.concurrent;

import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.concurrent.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.concurrent.ExecutionList;
import dev.mccue.guava.concurrent.ForwardingFuture;
import dev.mccue.guava.concurrent.ListenableFuture;
import dev.mccue.guava.concurrent.ThreadFactoryBuilder;
import dev.mccue.guava.concurrent.Uninterruptibles;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

@ElementTypesAreNonnullByDefault
public final class JdkFutureAdapters {
    public static <V> ListenableFuture<V> listenInPoolThread(Future<V> future) {
        if (future instanceof ListenableFuture) {
            return (ListenableFuture)future;
        }
        return new ListenableFutureAdapter<V>(future);
    }

    public static <V> ListenableFuture<V> listenInPoolThread(Future<V> future, Executor executor) {
        Preconditions.checkNotNull((Object)executor);
        if (future instanceof ListenableFuture) {
            return (ListenableFuture)future;
        }
        return new ListenableFutureAdapter<V>(future, executor);
    }

    private JdkFutureAdapters() {
    }

    private static class ListenableFutureAdapter<V>
    extends ForwardingFuture<V>
    implements ListenableFuture<V> {
        private static final ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ListenableFutureAdapter-thread-%d").build();
        private static final Executor defaultAdapterExecutor = Executors.newCachedThreadPool(threadFactory);
        private final Executor adapterExecutor;
        private final ExecutionList executionList = new ExecutionList();
        private final AtomicBoolean hasListeners = new AtomicBoolean(false);
        private final Future<V> delegate;

        ListenableFutureAdapter(Future<V> delegate) {
            this(delegate, defaultAdapterExecutor);
        }

        ListenableFutureAdapter(Future<V> delegate, Executor adapterExecutor) {
            this.delegate = (Future)Preconditions.checkNotNull(delegate);
            this.adapterExecutor = (Executor)Preconditions.checkNotNull((Object)adapterExecutor);
        }

        @Override
        protected Future<V> delegate() {
            return this.delegate;
        }

        @Override
        public void addListener(Runnable listener, Executor exec) {
            this.executionList.add(listener, exec);
            if (this.hasListeners.compareAndSet(false, true)) {
                if (this.delegate.isDone()) {
                    this.executionList.execute();
                    return;
                }
                this.adapterExecutor.execute(() -> {
                    try {
                        Uninterruptibles.getUninterruptibly(this.delegate);
                    }
                    catch (Error | RuntimeException | ExecutionException throwable) {
                        // empty catch block
                    }
                    this.executionList.execute();
                });
            }
        }
    }
}

