/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.concurrent;

import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.concurrent.ElementTypesAreNonnullByDefault;
import dev.mccue.jsr305.CheckForNull;

@ElementTypesAreNonnullByDefault
final class Platform {
    static boolean isInstanceOfThrowableClass(@CheckForNull Throwable t, Class<? extends Throwable> expectedClass) {
        return expectedClass.isInstance(t);
    }

    static void restoreInterruptIfIsInterruptedException(Throwable t) {
        Preconditions.checkNotNull((Object)t);
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private Platform() {
    }
}

