/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.graph;

import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.collect.AbstractIterator;
import dev.mccue.guava.collect.UnmodifiableIterator;
import dev.mccue.guava.graph.ElementTypesAreNonnullByDefault;
import dev.mccue.jsr305.CheckForNull;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;

@ElementTypesAreNonnullByDefault
abstract class MultiEdgesConnecting<E>
extends AbstractSet<E> {
    private final Map<E, ?> outEdgeToNode;
    private final Object targetNode;

    MultiEdgesConnecting(Map<E, ?> outEdgeToNode, Object targetNode) {
        this.outEdgeToNode = (Map)Preconditions.checkNotNull(outEdgeToNode);
        this.targetNode = Preconditions.checkNotNull((Object)targetNode);
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        final Iterator<Map.Entry<E, ?>> entries = this.outEdgeToNode.entrySet().iterator();
        return new AbstractIterator<E>(){

            @CheckForNull
            protected E computeNext() {
                while (entries.hasNext()) {
                    Map.Entry entry = (Map.Entry)entries.next();
                    if (!MultiEdgesConnecting.this.targetNode.equals(entry.getValue())) continue;
                    return entry.getKey();
                }
                return this.endOfData();
            }
        };
    }

    @Override
    public boolean contains(@CheckForNull Object edge) {
        return this.targetNode.equals(this.outEdgeToNode.get(edge));
    }
}

