/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.hash;

import dev.mccue.guava.hash.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.primitives.Longs;

@ElementTypesAreNonnullByDefault
final class LittleEndianByteArray {
    private static final LittleEndianBytes byteArray;

    static long load64(byte[] input, int offset) {
        assert (input.length >= offset + 8);
        return byteArray.getLongLittleEndian(input, offset);
    }

    static long load64Safely(byte[] input, int offset, int length) {
        long result = 0L;
        int limit = Math.min(length, 8);
        for (int i = 0; i < limit; ++i) {
            result |= ((long)input[offset + i] & 0xFFL) << i * 8;
        }
        return result;
    }

    static void store64(byte[] sink, int offset, long value) {
        assert (offset >= 0 && offset + 8 <= sink.length);
        byteArray.putLongLittleEndian(sink, offset, value);
    }

    static int load32(byte[] source, int offset) {
        return source[offset] & 0xFF | (source[offset + 1] & 0xFF) << 8 | (source[offset + 2] & 0xFF) << 16 | (source[offset + 3] & 0xFF) << 24;
    }

    static boolean usingUnsafe() {
        return false;
    }

    private LittleEndianByteArray() {
    }

    static {
        JavaLittleEndianBytes theGetter = JavaLittleEndianBytes.INSTANCE;
        byteArray = theGetter;
    }

    private static interface LittleEndianBytes {
        public long getLongLittleEndian(byte[] var1, int var2);

        public void putLongLittleEndian(byte[] var1, int var2, long var3);
    }

    private static enum JavaLittleEndianBytes implements LittleEndianBytes
    {
        INSTANCE{

            @Override
            public long getLongLittleEndian(byte[] source, int offset) {
                return Longs.fromBytes((byte)source[offset + 7], (byte)source[offset + 6], (byte)source[offset + 5], (byte)source[offset + 4], (byte)source[offset + 3], (byte)source[offset + 2], (byte)source[offset + 1], (byte)source[offset]);
            }

            @Override
            public void putLongLittleEndian(byte[] sink, int offset, long value) {
                long mask = 255L;
                for (int i = 0; i < 8; ++i) {
                    sink[offset + i] = (byte)((value & mask) >> i * 8);
                    mask <<= 8;
                }
            }
        };

    }
}

