/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.hash;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.mccue.guava.base.Objects;
import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.base.Predicate;
import dev.mccue.guava.hash.BloomFilterStrategies;
import dev.mccue.guava.hash.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.hash.Funnel;
import dev.mccue.guava.hash.ParametricNullness;
import dev.mccue.guava.math.DoubleMath;
import dev.mccue.guava.math.LongMath;
import dev.mccue.guava.primitives.SignedBytes;
import dev.mccue.guava.primitives.UnsignedBytes;
import dev.mccue.jsr305.CheckForNull;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.RoundingMode;
import java.util.stream.Collector;

@ElementTypesAreNonnullByDefault
public final class BloomFilter<T>
implements Predicate<T>,
Serializable {
    private final BloomFilterStrategies.LockFreeBitArray bits;
    private final int numHashFunctions;
    private final Funnel<? super T> funnel;
    private final Strategy strategy;
    private static final double LOG_TWO = Math.log(2.0);
    private static final double SQUARED_LOG_TWO = LOG_TWO * LOG_TWO;
    private static final long serialVersionUID = -889275714L;

    private BloomFilter(BloomFilterStrategies.LockFreeBitArray bits, int numHashFunctions, Funnel<? super T> funnel, Strategy strategy) {
        Preconditions.checkArgument((numHashFunctions > 0 ? 1 : 0) != 0, (String)"numHashFunctions (%s) must be > 0", (int)numHashFunctions);
        Preconditions.checkArgument((numHashFunctions <= 255 ? 1 : 0) != 0, (String)"numHashFunctions (%s) must be <= 255", (int)numHashFunctions);
        this.bits = (BloomFilterStrategies.LockFreeBitArray)Preconditions.checkNotNull((Object)bits);
        this.numHashFunctions = numHashFunctions;
        this.funnel = (Funnel)Preconditions.checkNotNull(funnel);
        this.strategy = (Strategy)Preconditions.checkNotNull((Object)strategy);
    }

    public BloomFilter<T> copy() {
        return new BloomFilter<T>(this.bits.copy(), this.numHashFunctions, this.funnel, this.strategy);
    }

    public boolean mightContain(@ParametricNullness T object) {
        return this.strategy.mightContain(object, this.funnel, this.numHashFunctions, this.bits);
    }

    @Deprecated
    public boolean apply(@ParametricNullness T input) {
        return this.mightContain(input);
    }

    @CanIgnoreReturnValue
    public boolean put(@ParametricNullness T object) {
        return this.strategy.put(object, this.funnel, this.numHashFunctions, this.bits);
    }

    public double expectedFpp() {
        return Math.pow((double)this.bits.bitCount() / (double)this.bitSize(), this.numHashFunctions);
    }

    public long approximateElementCount() {
        long bitSize = this.bits.bitSize();
        long bitCount = this.bits.bitCount();
        double fractionOfBitsSet = (double)bitCount / (double)bitSize;
        return DoubleMath.roundToLong((double)(-Math.log1p(-fractionOfBitsSet) * (double)bitSize / (double)this.numHashFunctions), (RoundingMode)RoundingMode.HALF_UP);
    }

    long bitSize() {
        return this.bits.bitSize();
    }

    public boolean isCompatible(BloomFilter<T> that) {
        Preconditions.checkNotNull(that);
        return this != that && this.numHashFunctions == that.numHashFunctions && this.bitSize() == that.bitSize() && this.strategy.equals(that.strategy) && this.funnel.equals(that.funnel);
    }

    public void putAll(BloomFilter<T> that) {
        Preconditions.checkNotNull(that);
        Preconditions.checkArgument((this != that ? 1 : 0) != 0, (Object)"Cannot combine a BloomFilter with itself.");
        Preconditions.checkArgument((this.numHashFunctions == that.numHashFunctions ? 1 : 0) != 0, (String)"BloomFilters must have the same number of hash functions (%s != %s)", (int)this.numHashFunctions, (int)that.numHashFunctions);
        Preconditions.checkArgument((this.bitSize() == that.bitSize() ? 1 : 0) != 0, (String)"BloomFilters must have the same size underlying bit arrays (%s != %s)", (long)this.bitSize(), (long)that.bitSize());
        Preconditions.checkArgument((boolean)this.strategy.equals(that.strategy), (String)"BloomFilters must have equal strategies (%s != %s)", (Object)this.strategy, (Object)that.strategy);
        Preconditions.checkArgument((boolean)this.funnel.equals(that.funnel), (String)"BloomFilters must have equal funnels (%s != %s)", this.funnel, that.funnel);
        this.bits.putAll(that.bits);
    }

    public boolean equals(@CheckForNull Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BloomFilter) {
            BloomFilter that = (BloomFilter)object;
            return this.numHashFunctions == that.numHashFunctions && this.funnel.equals(that.funnel) && this.bits.equals(that.bits) && this.strategy.equals(that.strategy);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.numHashFunctions, this.funnel, this.strategy, this.bits});
    }

    public static <T> Collector<T, ?, BloomFilter<T>> toBloomFilter(Funnel<? super T> funnel, long expectedInsertions) {
        return BloomFilter.toBloomFilter(funnel, expectedInsertions, 0.03);
    }

    public static <T> Collector<T, ?, BloomFilter<T>> toBloomFilter(Funnel<? super T> funnel, long expectedInsertions, double fpp) {
        Preconditions.checkNotNull(funnel);
        Preconditions.checkArgument((expectedInsertions >= 0L ? 1 : 0) != 0, (String)"Expected insertions (%s) must be >= 0", (long)expectedInsertions);
        Preconditions.checkArgument((fpp > 0.0 ? 1 : 0) != 0, (String)"False positive probability (%s) must be > 0.0", (Object)fpp);
        Preconditions.checkArgument((fpp < 1.0 ? 1 : 0) != 0, (String)"False positive probability (%s) must be < 1.0", (Object)fpp);
        return Collector.of(() -> BloomFilter.create(funnel, expectedInsertions, fpp), BloomFilter::put, (bf1, bf2) -> {
            bf1.putAll((BloomFilter)bf2);
            return bf1;
        }, Collector.Characteristics.UNORDERED, Collector.Characteristics.CONCURRENT);
    }

    public static <T> BloomFilter<T> create(Funnel<? super T> funnel, int expectedInsertions, double fpp) {
        return BloomFilter.create(funnel, (long)expectedInsertions, fpp);
    }

    public static <T> BloomFilter<T> create(Funnel<? super T> funnel, long expectedInsertions, double fpp) {
        return BloomFilter.create(funnel, expectedInsertions, fpp, BloomFilterStrategies.MURMUR128_MITZ_64);
    }

    static <T> BloomFilter<T> create(Funnel<? super T> funnel, long expectedInsertions, double fpp, Strategy strategy) {
        Preconditions.checkNotNull(funnel);
        Preconditions.checkArgument((expectedInsertions >= 0L ? 1 : 0) != 0, (String)"Expected insertions (%s) must be >= 0", (long)expectedInsertions);
        Preconditions.checkArgument((fpp > 0.0 ? 1 : 0) != 0, (String)"False positive probability (%s) must be > 0.0", (Object)fpp);
        Preconditions.checkArgument((fpp < 1.0 ? 1 : 0) != 0, (String)"False positive probability (%s) must be < 1.0", (Object)fpp);
        Preconditions.checkNotNull((Object)strategy);
        if (expectedInsertions == 0L) {
            expectedInsertions = 1L;
        }
        long numBits = BloomFilter.optimalNumOfBits(expectedInsertions, fpp);
        int numHashFunctions = BloomFilter.optimalNumOfHashFunctions(fpp);
        try {
            return new BloomFilter<T>(new BloomFilterStrategies.LockFreeBitArray(numBits), numHashFunctions, funnel, strategy);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not create BloomFilter of " + numBits + " bits", e);
        }
    }

    public static <T> BloomFilter<T> create(Funnel<? super T> funnel, int expectedInsertions) {
        return BloomFilter.create(funnel, (long)expectedInsertions);
    }

    public static <T> BloomFilter<T> create(Funnel<? super T> funnel, long expectedInsertions) {
        return BloomFilter.create(funnel, expectedInsertions, 0.03);
    }

    static int optimalNumOfHashFunctions(double p) {
        return Math.max(1, (int)Math.round(-Math.log(p) / LOG_TWO));
    }

    static long optimalNumOfBits(long n, double p) {
        if (p == 0.0) {
            p = Double.MIN_VALUE;
        }
        return (long)((double)(-n) * Math.log(p) / SQUARED_LOG_TWO);
    }

    private Object writeReplace() {
        return new SerialForm(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    public void writeTo(OutputStream out) throws IOException {
        DataOutputStream dout = new DataOutputStream(out);
        dout.writeByte(SignedBytes.checkedCast((long)this.strategy.ordinal()));
        dout.writeByte(UnsignedBytes.checkedCast((long)this.numHashFunctions));
        dout.writeInt(this.bits.data.length());
        for (int i = 0; i < this.bits.data.length(); ++i) {
            dout.writeLong(this.bits.data.get(i));
        }
    }

    public static <T> BloomFilter<T> readFrom(InputStream in, Funnel<? super T> funnel) throws IOException {
        Preconditions.checkNotNull((Object)in, (Object)"InputStream");
        Preconditions.checkNotNull(funnel, (Object)"Funnel");
        int strategyOrdinal = -1;
        int numHashFunctions = -1;
        int dataLength = -1;
        try {
            DataInputStream din = new DataInputStream(in);
            strategyOrdinal = din.readByte();
            numHashFunctions = UnsignedBytes.toInt((byte)din.readByte());
            dataLength = din.readInt();
            BloomFilterStrategies strategy = BloomFilterStrategies.values()[strategyOrdinal];
            BloomFilterStrategies.LockFreeBitArray dataArray = new BloomFilterStrategies.LockFreeBitArray(LongMath.checkedMultiply((long)dataLength, (long)64L));
            for (int i = 0; i < dataLength; ++i) {
                dataArray.putData(i, din.readLong());
            }
            return new BloomFilter<T>(dataArray, numHashFunctions, funnel, strategy);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            String message = "Unable to deserialize BloomFilter from InputStream. strategyOrdinal: " + strategyOrdinal + " numHashFunctions: " + numHashFunctions + " dataLength: " + dataLength;
            throw new IOException(message, e);
        }
    }

    static interface Strategy
    extends Serializable {
        public <T> boolean put(@ParametricNullness T var1, Funnel<? super T> var2, int var3, BloomFilterStrategies.LockFreeBitArray var4);

        public <T> boolean mightContain(@ParametricNullness T var1, Funnel<? super T> var2, int var3, BloomFilterStrategies.LockFreeBitArray var4);

        public int ordinal();
    }

    private static class SerialForm<T>
    implements Serializable {
        final long[] data;
        final int numHashFunctions;
        final Funnel<? super T> funnel;
        final Strategy strategy;
        private static final long serialVersionUID = 1L;

        SerialForm(BloomFilter<T> bf) {
            this.data = BloomFilterStrategies.LockFreeBitArray.toPlainArray(((BloomFilter)bf).bits.data);
            this.numHashFunctions = ((BloomFilter)bf).numHashFunctions;
            this.funnel = ((BloomFilter)bf).funnel;
            this.strategy = ((BloomFilter)bf).strategy;
        }

        Object readResolve() {
            return new BloomFilter(new BloomFilterStrategies.LockFreeBitArray(this.data), this.numHashFunctions, this.funnel, this.strategy);
        }
    }
}

