/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.io;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.io.ByteStreams;
import dev.mccue.guava.io.CharSink;
import dev.mccue.guava.io.ElementTypesAreNonnullByDefault;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;

@ElementTypesAreNonnullByDefault
public abstract class ByteSink {
    protected ByteSink() {
    }

    public CharSink asCharSink(Charset charset) {
        return new AsCharSink(charset);
    }

    public abstract OutputStream openStream() throws IOException;

    public OutputStream openBufferedStream() throws IOException {
        OutputStream out = this.openStream();
        return out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out);
    }

    public void write(byte[] bytes) throws IOException {
        Preconditions.checkNotNull((Object)bytes);
        try (OutputStream out = this.openStream();){
            out.write(bytes);
        }
    }

    @CanIgnoreReturnValue
    public long writeFrom(InputStream input) throws IOException {
        Preconditions.checkNotNull((Object)input);
        try (OutputStream out = this.openStream();){
            long l = ByteStreams.copy(input, out);
            return l;
        }
    }

    private final class AsCharSink
    extends CharSink {
        private final Charset charset;

        private AsCharSink(Charset charset) {
            this.charset = (Charset)Preconditions.checkNotNull((Object)charset);
        }

        @Override
        public Writer openStream() throws IOException {
            return new OutputStreamWriter(ByteSink.this.openStream(), this.charset);
        }

        public String toString() {
            return ByteSink.this.toString() + ".asCharSink(" + this.charset + ")";
        }
    }
}

