/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.io;

import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.io.ElementTypesAreNonnullByDefault;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@ElementTypesAreNonnullByDefault
public final class CountingOutputStream
extends FilterOutputStream {
    private long count;

    public CountingOutputStream(OutputStream out) {
        super((OutputStream)Preconditions.checkNotNull((Object)out));
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.count += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.count;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

